/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.health;

import io.smallrye.common.annotation.Identifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.common.Node;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
public class KafkaHealthCheck
implements HealthCheck {
    @Inject
    @Identifier(value="default-kafka-broker")
    Map<String, Object> config;
    private AdminClient client;

    @PostConstruct
    void init() {
        HashMap<String, Object> conf = new HashMap<String, Object>(this.config);
        conf.put("request.timeout.ms", "5000");
        this.client = AdminClient.create(conf);
    }

    @PreDestroy
    void stop() {
        this.client.close();
    }

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"Kafka connection health check").up();
        try {
            StringBuilder nodes = new StringBuilder();
            for (Node node : (Collection)this.client.describeCluster().nodes().get()) {
                if (nodes.length() > 0) {
                    nodes.append(',');
                }
                nodes.append(node.host()).append(':').append(node.port());
            }
            return builder.withData("nodes", nodes.toString()).build();
        }
        catch (Exception e) {
            return builder.down().withData("reason", e.getMessage()).build();
        }
    }
}

