/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.deployment.devservices;

import io.quarkus.devconsole.runtime.spi.DevConsolePostHandler;
import io.quarkus.oidc.runtime.devui.OidcDevServicesUtils;
import io.smallrye.mutiny.Uni;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;
import java.time.Duration;
import java.util.Map;
import org.jboss.logging.Logger;

public class OidcPasswordClientCredHandler
extends DevConsolePostHandler {
    private static final Logger LOG = Logger.getLogger(OidcPasswordClientCredHandler.class);
    Map<String, String> users;
    Vertx vertxInstance;
    Duration timeout;
    Map<String, String> passwordGrantOptions;
    Map<String, String> clientCredGrantOptions;

    public OidcPasswordClientCredHandler(Vertx vertxInstance, Duration timeout, Map<String, Map<String, String>> grantOptions) {
        this(vertxInstance, timeout, Map.of(), grantOptions);
    }

    public OidcPasswordClientCredHandler(Vertx vertxInstance, Duration timeout, Map<String, String> users, Map<String, Map<String, String>> grantOptions) {
        this.vertxInstance = vertxInstance;
        this.timeout = timeout;
        this.users = users;
        this.passwordGrantOptions = grantOptions.get("password");
        this.clientCredGrantOptions = grantOptions.get("client");
    }

    protected void handlePostAsync(RoutingContext event, MultiMap form) throws Exception {
        Uni result = "password".equals(form.get("grant")) ? OidcDevServicesUtils.testServiceWithPassword((String)form.get("tokenUrl"), (String)form.get("serviceUrl"), (String)form.get("client"), (String)form.get("clientSecret"), (String)form.get("user"), (String)form.get("password"), (Vertx)this.vertxInstance, (Duration)this.timeout, this.passwordGrantOptions, this.users) : OidcDevServicesUtils.testServiceWithClientCred((String)form.get("tokenUrl"), (String)form.get("serviceUrl"), (String)form.get("client"), (String)form.get("clientSecret"), (Vertx)this.vertxInstance, (Duration)this.timeout, this.clientCredGrantOptions);
        event.put("result", result.onFailure().recoverWithNull().await().indefinitely());
    }

    protected void actionSuccess(RoutingContext event) {
        event.response().setStatusCode(200);
        String result = (String)event.get("result");
        if (result != null) {
            event.response().end(result);
        }
    }
}

