/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.deployment.devservices;

import io.quarkus.devconsole.runtime.spi.DevConsolePostHandler;
import io.quarkus.oidc.runtime.devui.OidcDevServicesUtils;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;
import java.time.Duration;
import org.jboss.logging.Logger;

public class OidcTestServiceHandler
extends DevConsolePostHandler {
    private static final Logger LOG = Logger.getLogger(OidcTestServiceHandler.class);
    Vertx vertxInstance;
    Duration timeout;

    public OidcTestServiceHandler(Vertx vertxInstance, Duration timeout) {
        this.vertxInstance = vertxInstance;
        this.timeout = timeout;
    }

    protected void handlePostAsync(RoutingContext event, MultiMap form) throws Exception {
        this.testServiceInternal(event, form.get("serviceUrl"), form.get("token"));
    }

    private void testServiceInternal(RoutingContext event, String serviceUrl, String token) {
        Integer statusCode = (Integer)OidcDevServicesUtils.testServiceWithToken((String)serviceUrl, (String)token, (Vertx)this.vertxInstance).onFailure().recoverWithNull().await().atMost(this.timeout);
        event.put("result", (Object)String.valueOf(statusCode));
    }

    protected void actionSuccess(RoutingContext event) {
        event.response().setStatusCode(200);
        String result = (String)event.get("result");
        if (result != null) {
            event.response().end(result);
        }
    }
}

