/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.deployment.devservices;

import io.quarkus.devconsole.runtime.spi.DevConsolePostHandler;
import io.quarkus.oidc.runtime.devui.OidcDevServicesUtils;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;
import java.time.Duration;
import java.util.Map;
import org.jboss.logging.Logger;

public class OidcAuthorizationCodePostHandler
extends DevConsolePostHandler {
    private static final Logger LOG = Logger.getLogger(OidcAuthorizationCodePostHandler.class);
    Vertx vertxInstance;
    Duration timeout;
    Map<String, String> grantOptions;

    public OidcAuthorizationCodePostHandler(Vertx vertxInstance, Duration timeout, Map<String, Map<String, String>> grantOptions) {
        this.vertxInstance = vertxInstance;
        this.timeout = timeout;
        this.grantOptions = grantOptions.get("code");
    }

    protected void handlePostAsync(RoutingContext event, MultiMap form) throws Exception {
        try {
            String tokens = (String)OidcDevServicesUtils.getTokens((String)form.get("tokenUrl"), (String)form.get("client"), (String)form.get("clientSecret"), (String)form.get("authorizationCode"), (String)form.get("redirectUri"), (Vertx)this.vertxInstance, this.grantOptions).onFailure().recoverWithNull().await().atMost(this.timeout);
            event.put("tokens", (Object)tokens);
        }
        catch (Throwable t) {
            LOG.errorf("Token can not be acquired from OpenId Connect provider: %s", (Object)t.toString());
        }
    }

    protected void actionSuccess(RoutingContext event) {
        event.response().setStatusCode(200);
        String tokens = (String)event.get("tokens");
        if (tokens != null) {
            event.response().end(tokens);
        }
    }
}

