/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.file;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.file.CopyOptions;
import io.vertx.core.file.OpenOptions;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.core.file.AsyncFile;
import io.vertx.mutiny.core.file.FileProps;
import io.vertx.mutiny.core.file.FileSystemProps;
import java.util.List;

@MutinyGen(value=io.vertx.core.file.FileSystem.class)
public class FileSystem {
    public static final TypeArg<FileSystem> __TYPE_ARG = new TypeArg(obj -> new FileSystem((io.vertx.core.file.FileSystem)obj), FileSystem::getDelegate);
    private final io.vertx.core.file.FileSystem delegate;

    public FileSystem(io.vertx.core.file.FileSystem delegate) {
        this.delegate = delegate;
    }

    public FileSystem(Object delegate) {
        this.delegate = (io.vertx.core.file.FileSystem)delegate;
    }

    FileSystem() {
        this.delegate = null;
    }

    public io.vertx.core.file.FileSystem getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSystem that = (FileSystem)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @CheckReturnValue
    public Uni<Void> copy(String from, String to) {
        return AsyncResultUni.toUni(handler -> this.delegate.copy(from, to, handler));
    }

    public Void copyAndAwait(String from, String to) {
        return (Void)this.copy(from, to).await().indefinitely();
    }

    @Fluent
    public FileSystem copyAndForget(String from, String to) {
        this.copy(from, to).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> copy(String from, String to, CopyOptions options) {
        return AsyncResultUni.toUni(handler -> this.delegate.copy(from, to, options, handler));
    }

    public Void copyAndAwait(String from, String to, CopyOptions options) {
        return (Void)this.copy(from, to, options).await().indefinitely();
    }

    @Fluent
    public FileSystem copyAndForget(String from, String to, CopyOptions options) {
        this.copy(from, to, options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    public FileSystem copyBlocking(String from, String to) {
        this.delegate.copyBlocking(from, to);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> copyRecursive(String from, String to, boolean recursive) {
        return AsyncResultUni.toUni(handler -> this.delegate.copyRecursive(from, to, recursive, handler));
    }

    public Void copyRecursiveAndAwait(String from, String to, boolean recursive) {
        return (Void)this.copyRecursive(from, to, recursive).await().indefinitely();
    }

    @Fluent
    public FileSystem copyRecursiveAndForget(String from, String to, boolean recursive) {
        this.copyRecursive(from, to, recursive).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    public FileSystem copyRecursiveBlocking(String from, String to, boolean recursive) {
        this.delegate.copyRecursiveBlocking(from, to, recursive);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> move(String from, String to) {
        return AsyncResultUni.toUni(handler -> this.delegate.move(from, to, handler));
    }

    public Void moveAndAwait(String from, String to) {
        return (Void)this.move(from, to).await().indefinitely();
    }

    @Fluent
    public FileSystem moveAndForget(String from, String to) {
        this.move(from, to).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> move(String from, String to, CopyOptions options) {
        return AsyncResultUni.toUni(handler -> this.delegate.move(from, to, options, handler));
    }

    public Void moveAndAwait(String from, String to, CopyOptions options) {
        return (Void)this.move(from, to, options).await().indefinitely();
    }

    @Fluent
    public FileSystem moveAndForget(String from, String to, CopyOptions options) {
        this.move(from, to, options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    public FileSystem moveBlocking(String from, String to) {
        this.delegate.moveBlocking(from, to);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> truncate(String path, long len) {
        return AsyncResultUni.toUni(handler -> this.delegate.truncate(path, len, handler));
    }

    public Void truncateAndAwait(String path, long len) {
        return (Void)this.truncate(path, len).await().indefinitely();
    }

    @Fluent
    public FileSystem truncateAndForget(String path, long len) {
        this.truncate(path, len).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    public FileSystem truncateBlocking(String path, long len) {
        this.delegate.truncateBlocking(path, len);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> chmod(String path, String perms) {
        return AsyncResultUni.toUni(handler -> this.delegate.chmod(path, perms, handler));
    }

    public Void chmodAndAwait(String path, String perms) {
        return (Void)this.chmod(path, perms).await().indefinitely();
    }

    @Fluent
    public FileSystem chmodAndForget(String path, String perms) {
        this.chmod(path, perms).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    public FileSystem chmodBlocking(String path, String perms) {
        this.delegate.chmodBlocking(path, perms);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> chmodRecursive(String path, String perms, String dirPerms) {
        return AsyncResultUni.toUni(handler -> this.delegate.chmodRecursive(path, perms, dirPerms, handler));
    }

    public Void chmodRecursiveAndAwait(String path, String perms, String dirPerms) {
        return (Void)this.chmodRecursive(path, perms, dirPerms).await().indefinitely();
    }

    @Fluent
    public FileSystem chmodRecursiveAndForget(String path, String perms, String dirPerms) {
        this.chmodRecursive(path, perms, dirPerms).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    public FileSystem chmodRecursiveBlocking(String path, String perms, String dirPerms) {
        this.delegate.chmodRecursiveBlocking(path, perms, dirPerms);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> chown(String path, String user, String group) {
        return AsyncResultUni.toUni(handler -> this.delegate.chown(path, user, group, handler));
    }

    public Void chownAndAwait(String path, String user, String group) {
        return (Void)this.chown(path, user, group).await().indefinitely();
    }

    @Fluent
    public FileSystem chownAndForget(String path, String user, String group) {
        this.chown(path, user, group).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    public FileSystem chownBlocking(String path, String user, String group) {
        this.delegate.chownBlocking(path, user, group);
        return this;
    }

    @CheckReturnValue
    public Uni<FileProps> props(String path) {
        return AsyncResultUni.toUni(handler -> this.delegate.props(path, (Handler)new Handler<AsyncResult<io.vertx.core.file.FileProps>>(){

            public void handle(AsyncResult<io.vertx.core.file.FileProps> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)FileProps.newInstance((io.vertx.core.file.FileProps)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public FileProps propsAndAwait(String path) {
        return (FileProps)this.props(path).await().indefinitely();
    }

    @Fluent
    public FileSystem propsAndForget(String path) {
        this.props(path).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public FileProps propsBlocking(String path) {
        FileProps ret = FileProps.newInstance(this.delegate.propsBlocking(path));
        return ret;
    }

    @CheckReturnValue
    public Uni<FileProps> lprops(String path) {
        return AsyncResultUni.toUni(handler -> this.delegate.lprops(path, (Handler)new Handler<AsyncResult<io.vertx.core.file.FileProps>>(){

            public void handle(AsyncResult<io.vertx.core.file.FileProps> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)FileProps.newInstance((io.vertx.core.file.FileProps)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public FileProps lpropsAndAwait(String path) {
        return (FileProps)this.lprops(path).await().indefinitely();
    }

    @Fluent
    public FileSystem lpropsAndForget(String path) {
        this.lprops(path).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public FileProps lpropsBlocking(String path) {
        FileProps ret = FileProps.newInstance(this.delegate.lpropsBlocking(path));
        return ret;
    }

    @CheckReturnValue
    public Uni<Void> link(String link, String existing) {
        return AsyncResultUni.toUni(handler -> this.delegate.link(link, existing, handler));
    }

    public Void linkAndAwait(String link, String existing) {
        return (Void)this.link(link, existing).await().indefinitely();
    }

    @Fluent
    public FileSystem linkAndForget(String link, String existing) {
        this.link(link, existing).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    public FileSystem linkBlocking(String link, String existing) {
        this.delegate.linkBlocking(link, existing);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> symlink(String link, String existing) {
        return AsyncResultUni.toUni(handler -> this.delegate.symlink(link, existing, handler));
    }

    public Void symlinkAndAwait(String link, String existing) {
        return (Void)this.symlink(link, existing).await().indefinitely();
    }

    @Fluent
    public FileSystem symlinkAndForget(String link, String existing) {
        this.symlink(link, existing).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    public FileSystem symlinkBlocking(String link, String existing) {
        this.delegate.symlinkBlocking(link, existing);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> unlink(String link) {
        return AsyncResultUni.toUni(handler -> this.delegate.unlink(link, handler));
    }

    public Void unlinkAndAwait(String link) {
        return (Void)this.unlink(link).await().indefinitely();
    }

    @Fluent
    public FileSystem unlinkAndForget(String link) {
        this.unlink(link).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    public FileSystem unlinkBlocking(String link) {
        this.delegate.unlinkBlocking(link);
        return this;
    }

    @CheckReturnValue
    public Uni<String> readSymlink(String link) {
        return AsyncResultUni.toUni(handler -> this.delegate.readSymlink(link, handler));
    }

    public String readSymlinkAndAwait(String link) {
        return (String)this.readSymlink(link).await().indefinitely();
    }

    @Fluent
    public FileSystem readSymlinkAndForget(String link) {
        this.readSymlink(link).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public String readSymlinkBlocking(String link) {
        String ret = this.delegate.readSymlinkBlocking(link);
        return ret;
    }

    @CheckReturnValue
    public Uni<Void> delete(String path) {
        return AsyncResultUni.toUni(handler -> this.delegate.delete(path, handler));
    }

    public Void deleteAndAwait(String path) {
        return (Void)this.delete(path).await().indefinitely();
    }

    @Fluent
    public FileSystem deleteAndForget(String path) {
        this.delete(path).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    public FileSystem deleteBlocking(String path) {
        this.delegate.deleteBlocking(path);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> deleteRecursive(String path, boolean recursive) {
        return AsyncResultUni.toUni(handler -> this.delegate.deleteRecursive(path, recursive, handler));
    }

    public Void deleteRecursiveAndAwait(String path, boolean recursive) {
        return (Void)this.deleteRecursive(path, recursive).await().indefinitely();
    }

    @Fluent
    public FileSystem deleteRecursiveAndForget(String path, boolean recursive) {
        this.deleteRecursive(path, recursive).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    public FileSystem deleteRecursiveBlocking(String path, boolean recursive) {
        this.delegate.deleteRecursiveBlocking(path, recursive);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> mkdir(String path) {
        return AsyncResultUni.toUni(handler -> this.delegate.mkdir(path, handler));
    }

    public Void mkdirAndAwait(String path) {
        return (Void)this.mkdir(path).await().indefinitely();
    }

    @Fluent
    public FileSystem mkdirAndForget(String path) {
        this.mkdir(path).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    public FileSystem mkdirBlocking(String path) {
        this.delegate.mkdirBlocking(path);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> mkdir(String path, String perms) {
        return AsyncResultUni.toUni(handler -> this.delegate.mkdir(path, perms, handler));
    }

    public Void mkdirAndAwait(String path, String perms) {
        return (Void)this.mkdir(path, perms).await().indefinitely();
    }

    @Fluent
    public FileSystem mkdirAndForget(String path, String perms) {
        this.mkdir(path, perms).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    public FileSystem mkdirBlocking(String path, String perms) {
        this.delegate.mkdirBlocking(path, perms);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> mkdirs(String path) {
        return AsyncResultUni.toUni(handler -> this.delegate.mkdirs(path, handler));
    }

    public Void mkdirsAndAwait(String path) {
        return (Void)this.mkdirs(path).await().indefinitely();
    }

    @Fluent
    public FileSystem mkdirsAndForget(String path) {
        this.mkdirs(path).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    public FileSystem mkdirsBlocking(String path) {
        this.delegate.mkdirsBlocking(path);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> mkdirs(String path, String perms) {
        return AsyncResultUni.toUni(handler -> this.delegate.mkdirs(path, perms, handler));
    }

    public Void mkdirsAndAwait(String path, String perms) {
        return (Void)this.mkdirs(path, perms).await().indefinitely();
    }

    @Fluent
    public FileSystem mkdirsAndForget(String path, String perms) {
        this.mkdirs(path, perms).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    public FileSystem mkdirsBlocking(String path, String perms) {
        this.delegate.mkdirsBlocking(path, perms);
        return this;
    }

    @CheckReturnValue
    public Uni<List<String>> readDir(String path) {
        return AsyncResultUni.toUni(handler -> this.delegate.readDir(path, handler));
    }

    public List<String> readDirAndAwait(String path) {
        return (List)this.readDir(path).await().indefinitely();
    }

    @Fluent
    public FileSystem readDirAndForget(String path) {
        this.readDir(path).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public List<String> readDirBlocking(String path) {
        List ret = this.delegate.readDirBlocking(path);
        return ret;
    }

    @CheckReturnValue
    public Uni<List<String>> readDir(String path, String filter) {
        return AsyncResultUni.toUni(handler -> this.delegate.readDir(path, filter, handler));
    }

    public List<String> readDirAndAwait(String path, String filter) {
        return (List)this.readDir(path, filter).await().indefinitely();
    }

    @Fluent
    public FileSystem readDirAndForget(String path, String filter) {
        this.readDir(path, filter).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public List<String> readDirBlocking(String path, String filter) {
        List ret = this.delegate.readDirBlocking(path, filter);
        return ret;
    }

    @CheckReturnValue
    public Uni<Buffer> readFile(String path) {
        return AsyncResultUni.toUni(handler -> this.delegate.readFile(path, (Handler)new Handler<AsyncResult<io.vertx.core.buffer.Buffer>>(){

            public void handle(AsyncResult<io.vertx.core.buffer.Buffer> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Buffer.newInstance((io.vertx.core.buffer.Buffer)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Buffer readFileAndAwait(String path) {
        return (Buffer)this.readFile(path).await().indefinitely();
    }

    @Fluent
    public FileSystem readFileAndForget(String path) {
        this.readFile(path).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public Buffer readFileBlocking(String path) {
        Buffer ret = Buffer.newInstance(this.delegate.readFileBlocking(path));
        return ret;
    }

    @CheckReturnValue
    public Uni<Void> writeFile(String path, Buffer data) {
        return AsyncResultUni.toUni(handler -> this.delegate.writeFile(path, data.getDelegate(), handler));
    }

    public Void writeFileAndAwait(String path, Buffer data) {
        return (Void)this.writeFile(path, data).await().indefinitely();
    }

    @Fluent
    public FileSystem writeFileAndForget(String path, Buffer data) {
        this.writeFile(path, data).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    public FileSystem writeFileBlocking(String path, Buffer data) {
        this.delegate.writeFileBlocking(path, data.getDelegate());
        return this;
    }

    @CheckReturnValue
    public Uni<AsyncFile> open(String path, OpenOptions options) {
        return AsyncResultUni.toUni(handler -> this.delegate.open(path, options, (Handler)new Handler<AsyncResult<io.vertx.core.file.AsyncFile>>(){

            public void handle(AsyncResult<io.vertx.core.file.AsyncFile> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)AsyncFile.newInstance((io.vertx.core.file.AsyncFile)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public AsyncFile openAndAwait(String path, OpenOptions options) {
        return (AsyncFile)this.open(path, options).await().indefinitely();
    }

    @Fluent
    public FileSystem openAndForget(String path, OpenOptions options) {
        this.open(path, options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public AsyncFile openBlocking(String path, OpenOptions options) {
        AsyncFile ret = AsyncFile.newInstance(this.delegate.openBlocking(path, options));
        return ret;
    }

    @CheckReturnValue
    public Uni<Void> createFile(String path) {
        return AsyncResultUni.toUni(handler -> this.delegate.createFile(path, handler));
    }

    public Void createFileAndAwait(String path) {
        return (Void)this.createFile(path).await().indefinitely();
    }

    @Fluent
    public FileSystem createFileAndForget(String path) {
        this.createFile(path).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    public FileSystem createFileBlocking(String path) {
        this.delegate.createFileBlocking(path);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> createFile(String path, String perms) {
        return AsyncResultUni.toUni(handler -> this.delegate.createFile(path, perms, handler));
    }

    public Void createFileAndAwait(String path, String perms) {
        return (Void)this.createFile(path, perms).await().indefinitely();
    }

    @Fluent
    public FileSystem createFileAndForget(String path, String perms) {
        this.createFile(path, perms).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    public FileSystem createFileBlocking(String path, String perms) {
        this.delegate.createFileBlocking(path, perms);
        return this;
    }

    @CheckReturnValue
    public Uni<Boolean> exists(String path) {
        return AsyncResultUni.toUni(handler -> this.delegate.exists(path, handler));
    }

    public Boolean existsAndAwait(String path) {
        return (Boolean)this.exists(path).await().indefinitely();
    }

    @Fluent
    public FileSystem existsAndForget(String path) {
        this.exists(path).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public boolean existsBlocking(String path) {
        boolean ret = this.delegate.existsBlocking(path);
        return ret;
    }

    @CheckReturnValue
    public Uni<FileSystemProps> fsProps(String path) {
        return AsyncResultUni.toUni(handler -> this.delegate.fsProps(path, (Handler)new Handler<AsyncResult<io.vertx.core.file.FileSystemProps>>(){

            public void handle(AsyncResult<io.vertx.core.file.FileSystemProps> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)FileSystemProps.newInstance((io.vertx.core.file.FileSystemProps)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public FileSystemProps fsPropsAndAwait(String path) {
        return (FileSystemProps)this.fsProps(path).await().indefinitely();
    }

    @Fluent
    public FileSystem fsPropsAndForget(String path) {
        this.fsProps(path).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public FileSystemProps fsPropsBlocking(String path) {
        FileSystemProps ret = FileSystemProps.newInstance(this.delegate.fsPropsBlocking(path));
        return ret;
    }

    @CheckReturnValue
    public Uni<String> createTempDirectory(String prefix) {
        return AsyncResultUni.toUni(handler -> this.delegate.createTempDirectory(prefix, handler));
    }

    public String createTempDirectoryAndAwait(String prefix) {
        return (String)this.createTempDirectory(prefix).await().indefinitely();
    }

    @Fluent
    public FileSystem createTempDirectoryAndForget(String prefix) {
        this.createTempDirectory(prefix).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public String createTempDirectoryBlocking(String prefix) {
        String ret = this.delegate.createTempDirectoryBlocking(prefix);
        return ret;
    }

    @CheckReturnValue
    public Uni<String> createTempDirectory(String prefix, String perms) {
        return AsyncResultUni.toUni(handler -> this.delegate.createTempDirectory(prefix, perms, handler));
    }

    public String createTempDirectoryAndAwait(String prefix, String perms) {
        return (String)this.createTempDirectory(prefix, perms).await().indefinitely();
    }

    @Fluent
    public FileSystem createTempDirectoryAndForget(String prefix, String perms) {
        this.createTempDirectory(prefix, perms).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public String createTempDirectoryBlocking(String prefix, String perms) {
        String ret = this.delegate.createTempDirectoryBlocking(prefix, perms);
        return ret;
    }

    @CheckReturnValue
    public Uni<String> createTempDirectory(String dir, String prefix, String perms) {
        return AsyncResultUni.toUni(handler -> this.delegate.createTempDirectory(dir, prefix, perms, handler));
    }

    public String createTempDirectoryAndAwait(String dir, String prefix, String perms) {
        return (String)this.createTempDirectory(dir, prefix, perms).await().indefinitely();
    }

    @Fluent
    public FileSystem createTempDirectoryAndForget(String dir, String prefix, String perms) {
        this.createTempDirectory(dir, prefix, perms).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public String createTempDirectoryBlocking(String dir, String prefix, String perms) {
        String ret = this.delegate.createTempDirectoryBlocking(dir, prefix, perms);
        return ret;
    }

    @CheckReturnValue
    public Uni<String> createTempFile(String prefix, String suffix) {
        return AsyncResultUni.toUni(handler -> this.delegate.createTempFile(prefix, suffix, handler));
    }

    public String createTempFileAndAwait(String prefix, String suffix) {
        return (String)this.createTempFile(prefix, suffix).await().indefinitely();
    }

    @Fluent
    public FileSystem createTempFileAndForget(String prefix, String suffix) {
        this.createTempFile(prefix, suffix).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public String createTempFileBlocking(String prefix, String suffix) {
        String ret = this.delegate.createTempFileBlocking(prefix, suffix);
        return ret;
    }

    @CheckReturnValue
    public Uni<String> createTempFile(String prefix, String suffix, String perms) {
        return AsyncResultUni.toUni(handler -> this.delegate.createTempFile(prefix, suffix, perms, handler));
    }

    public String createTempFileAndAwait(String prefix, String suffix, String perms) {
        return (String)this.createTempFile(prefix, suffix, perms).await().indefinitely();
    }

    @Fluent
    public FileSystem createTempFileAndForget(String prefix, String suffix, String perms) {
        this.createTempFile(prefix, suffix, perms).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public String createTempFileBlocking(String prefix, String suffix, String perms) {
        String ret = this.delegate.createTempFileBlocking(prefix, suffix, perms);
        return ret;
    }

    @CheckReturnValue
    public Uni<String> createTempFile(String dir, String prefix, String suffix, String perms) {
        return AsyncResultUni.toUni(handler -> this.delegate.createTempFile(dir, prefix, suffix, perms, handler));
    }

    public String createTempFileAndAwait(String dir, String prefix, String suffix, String perms) {
        return (String)this.createTempFile(dir, prefix, suffix, perms).await().indefinitely();
    }

    @Fluent
    public FileSystem createTempFileAndForget(String dir, String prefix, String suffix, String perms) {
        this.createTempFile(dir, prefix, suffix, perms).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public String createTempFileBlocking(String dir, String prefix, String suffix, String perms) {
        String ret = this.delegate.createTempFileBlocking(dir, prefix, suffix, perms);
        return ret;
    }

    public static FileSystem newInstance(io.vertx.core.file.FileSystem arg) {
        return arg != null ? new FileSystem(arg) : null;
    }
}

