/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.api;

import io.smallrye.reactive.messaging.kafka.api.KafkaMessageMetadata;
import java.time.Instant;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.record.TimestampType;

public class IncomingKafkaRecordMetadata<K, T>
implements KafkaMessageMetadata<K> {
    private final ConsumerRecord<K, T> record;
    private volatile Headers headers;

    public IncomingKafkaRecordMetadata(ConsumerRecord<K, T> record) {
        this.record = record;
    }

    @Override
    public String getTopic() {
        return this.record.topic();
    }

    @Override
    public K getKey() {
        return (K)this.record.key();
    }

    @Override
    public int getPartition() {
        return this.record.partition();
    }

    @Override
    public Instant getTimestamp() {
        return Instant.ofEpochMilli(this.record.timestamp());
    }

    public TimestampType getTimestampType() {
        return this.record.timestampType();
    }

    public long getOffset() {
        return this.record.offset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Headers getHeaders() {
        if (this.headers == null) {
            IncomingKafkaRecordMetadata incomingKafkaRecordMetadata = this;
            synchronized (incomingKafkaRecordMetadata) {
                if (this.headers == null) {
                    RecordHeaders headers = new RecordHeaders();
                    if (this.record.headers() != null) {
                        for (Header header : this.record.headers()) {
                            headers.add((Header)new RecordHeader(header.key(), header.value()));
                        }
                    }
                    this.headers = headers;
                }
            }
        }
        return this.headers;
    }

    public ConsumerRecord<K, T> getRecord() {
        return this.record;
    }
}

