/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka;

import io.smallrye.mutiny.Uni;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.header.Headers;

public interface DeserializationFailureHandler<T> {
    public static final String DESERIALIZATION_FAILURE_REASON = "deserialization-failure-reason";
    public static final String DESERIALIZATION_FAILURE_CAUSE = "deserialization-failure-cause";
    public static final String DESERIALIZATION_FAILURE_IS_KEY = "deserialization-failure-key";
    public static final String DESERIALIZATION_FAILURE_TOPIC = "deserialization-failure-topic";
    public static final String DESERIALIZATION_FAILURE_DATA = "deserialization-failure-data";
    public static final String DESERIALIZATION_FAILURE_KEY_DATA = "deserialization-failure-key-data";
    public static final String DESERIALIZATION_FAILURE_VALUE_DATA = "deserialization-failure-value-data";
    public static final String DESERIALIZATION_FAILURE_DESERIALIZER = "deserialization-failure-deserializer";
    public static final String DESERIALIZATION_FAILURE_DLQ = "deserialization-failure-dlq";
    public static final byte[] TRUE_VALUE = "true".getBytes(StandardCharsets.UTF_8);

    default public T handleDeserializationFailure(String topic, boolean isKey, String deserializer, byte[] data, Exception exception, Headers headers) {
        return null;
    }

    default public T decorateDeserialization(Uni<T> deserialization, String topic, boolean isKey, String deserializer, byte[] data, Headers headers) {
        return (T)deserialization.onFailure().recoverWithItem(throwable -> this.handleDeserializationFailure(topic, isKey, deserializer, data, throwable instanceof Exception ? (Exception)throwable : new KafkaException(throwable), DeserializationFailureHandler.addFailureDetailsToHeaders(deserializer, topic, isKey, headers, data, throwable))).await().indefinitely();
    }

    public static Headers addFailureDetailsToHeaders(String deserializer, String topic, boolean isKey, Headers headers, byte[] data, Throwable failure) {
        String cause;
        String message = failure.getMessage();
        String string = cause = failure.getCause() != null ? failure.getCause().getMessage() : null;
        if (headers != null) {
            headers.add(DESERIALIZATION_FAILURE_DESERIALIZER, deserializer.getBytes(StandardCharsets.UTF_8));
            headers.add(DESERIALIZATION_FAILURE_DLQ, TRUE_VALUE);
            headers.add(DESERIALIZATION_FAILURE_TOPIC, topic.getBytes(StandardCharsets.UTF_8));
            if (isKey) {
                headers.add(DESERIALIZATION_FAILURE_IS_KEY, TRUE_VALUE);
            }
            if (message != null) {
                headers.add(DESERIALIZATION_FAILURE_REASON, message.getBytes(StandardCharsets.UTF_8));
            }
            if (cause != null) {
                headers.add(DESERIALIZATION_FAILURE_CAUSE, cause.getBytes(StandardCharsets.UTF_8));
            }
            if (data != null) {
                if (isKey) {
                    headers.add(DESERIALIZATION_FAILURE_KEY_DATA, data);
                } else {
                    headers.add(DESERIALIZATION_FAILURE_VALUE_DATA, data);
                }
                headers.add(DESERIALIZATION_FAILURE_DATA, data);
            }
        }
        return headers;
    }
}

