/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.circuit.breaker;

import io.smallrye.faulttolerance.core.circuit.breaker.RollingWindow;

final class NaiveRollingWindow
implements RollingWindow {
    private final boolean[] failures;
    private final int failureThreshold;
    private int index = 0;
    private long counter = 0L;

    NaiveRollingWindow(int size, int failureThreshold) {
        this.failures = new boolean[size];
        this.failureThreshold = failureThreshold;
    }

    @Override
    public synchronized boolean recordSuccess() {
        this.failures[this.nextIndex()] = false;
        return this.failureThresholdReached();
    }

    @Override
    public synchronized boolean recordFailure() {
        this.failures[this.nextIndex()] = true;
        return this.failureThresholdReached();
    }

    private int nextIndex() {
        ++this.counter;
        int result = this.index;
        this.index = (this.index + 1) % this.failures.length;
        return result;
    }

    private boolean failureThresholdReached() {
        if (this.counter < (long)this.failures.length) {
            return false;
        }
        int failures = 0;
        for (boolean failure : this.failures) {
            if (!failure) continue;
            ++failures;
        }
        return failures >= this.failureThreshold;
    }
}

