/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.spi.config;

import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.api.config.ServiceConfig;
import java.util.Collections;
import java.util.Map;

public class SimpleServiceConfig
implements ServiceConfig {
    private final String serviceName;
    private final ConfigWithType loadBalancerConfig;
    private final ConfigWithType serviceDiscoveryConfig;
    private final ConfigWithType serviceRegistrarConfig;

    private SimpleServiceConfig(String serviceName, ConfigWithType loadBalancerConfig, ConfigWithType serviceDiscoveryConfig, ConfigWithType serviceRegistrarConfig) {
        this.serviceName = serviceName;
        this.loadBalancerConfig = loadBalancerConfig;
        this.serviceDiscoveryConfig = serviceDiscoveryConfig;
        this.serviceRegistrarConfig = serviceRegistrarConfig;
    }

    @Override
    public String serviceName() {
        return this.serviceName;
    }

    @Override
    public ConfigWithType loadBalancer() {
        return this.loadBalancerConfig;
    }

    @Override
    public ConfigWithType serviceDiscovery() {
        return this.serviceDiscoveryConfig;
    }

    @Override
    public ConfigWithType serviceRegistrar() {
        return this.serviceRegistrarConfig;
    }

    public static class SimpleServiceRegistrarConfig
    implements ConfigWithType {
        private final String type;
        private final Map<String, String> parameters;

        public SimpleServiceRegistrarConfig(String type, Map<String, String> parameters) {
            this.type = type;
            this.parameters = parameters;
        }

        @Override
        public String type() {
            return this.type;
        }

        @Override
        public Map<String, String> parameters() {
            return this.parameters;
        }
    }

    public static class SimpleServiceDiscoveryConfig
    implements ConfigWithType {
        private final String type;
        private final Map<String, String> parameters;

        public SimpleServiceDiscoveryConfig(String type, Map<String, String> parameters) {
            this.type = type;
            this.parameters = Collections.unmodifiableMap(parameters);
        }

        @Override
        public String type() {
            return this.type;
        }

        @Override
        public Map<String, String> parameters() {
            return this.parameters;
        }
    }

    public static class SimpleLoadBalancerConfig
    implements ConfigWithType {
        private final String type;
        private final Map<String, String> parameters;

        public SimpleLoadBalancerConfig(String type, Map<String, String> parameters) {
            this.type = type;
            this.parameters = Collections.unmodifiableMap(parameters);
        }

        @Override
        public String type() {
            return this.type;
        }

        @Override
        public Map<String, String> parameters() {
            return this.parameters;
        }
    }

    public static class Builder {
        String serviceName;
        ConfigWithType loadBalancerConfig;
        ConfigWithType serviceDiscoveryConfig;
        ConfigWithType serviceRegistrarConfig;
        boolean secure;

        public Builder setLoadBalancer(ConfigWithType loadBalancer) {
            this.loadBalancerConfig = loadBalancer;
            return this;
        }

        public Builder setServiceDiscovery(ConfigWithType serviceDiscoveryConfig) {
            this.serviceDiscoveryConfig = serviceDiscoveryConfig;
            return this;
        }

        public Builder setServiceRegistrar(ConfigWithType serviceRegistrarConfig) {
            this.serviceRegistrarConfig = serviceRegistrarConfig;
            return this;
        }

        public Builder setServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder setSecure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public SimpleServiceConfig build() {
            return new SimpleServiceConfig(this.serviceName, this.loadBalancerConfig, this.serviceDiscoveryConfig, this.serviceRegistrarConfig);
        }
    }
}

