/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.gdalframework;

import com.sun.media.imageioimpl.common.ImageUtil;
import it.geosolutions.imageio.core.GCP;
import it.geosolutions.imageio.gdalframework.GDALCommonIIOImageMetadata;
import it.geosolutions.imageio.gdalframework.GDALImageReader;
import java.awt.Dimension;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.media.jai.JAI;
import javax.media.jai.RasterFactory;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.Driver;
import org.gdal.gdal.gdal;
import org.gdal.gdalconst.gdalconst;
import org.gdal.gdalconst.gdalconstConstants;

public final class GDALUtilities {
    public static final String STANDARD_METADATA_NAME = "javax_imageio_1.0";
    public static final String newLine = System.getProperty("line.separator");
    public static final String GDALMEMORYRASTER_MAXSIZE_KEY = "it.geosolutions.gdalmemoryrastermaxsize";
    private static final String CPL_DEBUG = "CPL_DEBUG";
    private static final Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.gdalframework");
    private static boolean available;
    private static boolean init;
    private static final Map<String, DriverCreateCapabilities> driversWritingCapabilities;
    public static final Dimension DEFAULT_TILE_SIZE;
    public static final int MIN_TILE_SIZE = 256;
    static final String NEWLINE;

    private GDALUtilities() {
    }

    private static boolean getAsBoolean(String value) {
        return value != null && value.trim().length() > 0 && (value.equalsIgnoreCase("ON") || value.equalsIgnoreCase("TRUE") || value.equalsIgnoreCase("YES"));
    }

    public static int retrieveGDALDataBufferType(int dataBufferType) {
        switch (dataBufferType) {
            case 0: {
                return gdalconstConstants.GDT_Byte;
            }
            case 1: {
                return gdalconstConstants.GDT_UInt16;
            }
            case 2: {
                return gdalconstConstants.GDT_Int16;
            }
            case 3: {
                return gdalconstConstants.GDT_Int32;
            }
            case 4: {
                return gdalconstConstants.GDT_Float32;
            }
            case 5: {
                return gdalconstConstants.GDT_Float64;
            }
        }
        return gdalconstConstants.GDT_Unknown;
    }

    public static int getCacheMax() {
        return gdal.GetCacheMax();
    }

    public static int getCacheUsed() {
        return gdal.GetCacheUsed();
    }

    public static List getJDKImageReaderWriterSPI(ServiceRegistry registry, String formatName, boolean isReader) {
        IIORegistry iioRegistry = (IIORegistry)registry;
        Class spiClass = isReader ? ImageReaderSpi.class : ImageWriterSpi.class;
        Iterator<ImageReaderSpi> iter = iioRegistry.getServiceProviders(spiClass, true);
        ArrayList<ImageReaderWriterSpi> list = new ArrayList<ImageReaderWriterSpi>();
        block0: while (iter.hasNext()) {
            ImageReaderWriterSpi provider = iter.next();
            String[] formatNames = provider.getFormatNames();
            int length = formatNames.length;
            for (int i = 0; i < length; ++i) {
                if (!formatNames[i].equalsIgnoreCase(formatName)) continue;
                list.add(provider);
                continue block0;
            }
        }
        return list;
    }

    public static void setCacheMax(int maxCacheSize) {
        gdal.SetCacheMax((int)maxCacheSize);
    }

    public static void setGdalCaching(boolean useCaching) {
        String sOption = useCaching ? "YES" : "NO";
        gdal.SetConfigOption((String)"GDAL_FORCE_CACHING", (String)sOption);
    }

    public static void setGdalPAM(boolean usePAM) {
        String sOption = usePAM ? "YES" : "NO";
        gdal.SetConfigOption((String)"GDAL_PAM_ENABLED", (String)sOption);
    }

    public static synchronized Dataset acquireDataSet(String name, int accessType) {
        if (!GDALUtilities.isGDALAvailable()) {
            return null;
        }
        return gdal.Open((String)name, (int)accessType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getGDALImageMetadata(String dataSetName) {
        Vector gdalImageMetadata;
        block7: {
            Dataset ds = GDALUtilities.acquireDataSet(dataSetName, gdalconst.GA_ReadOnly);
            if (ds != null) {
                try {
                    gdalImageMetadata = ds.GetMetadata_List("");
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    block8: {
                        Object var4_4 = null;
                        try {
                            GDALUtilities.closeDataSet(ds);
                        }
                        catch (Throwable e) {
                            if (!LOGGER.isLoggable(Level.FINEST)) break block8;
                            LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                        }
                    }
                    throw throwable;
                }
                try {
                    GDALUtilities.closeDataSet(ds);
                }
                catch (Throwable e) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                    }
                    break block7;
                }
            }
            gdalImageMetadata = null;
        }
        return gdalImageMetadata;
    }

    public static synchronized void closeDataSet(Dataset ds) {
        if (!GDALUtilities.isGDALAvailable()) {
            return;
        }
        if (ds == null) {
            throw new NullPointerException("The provided dataset is null");
        }
        ds.delete();
    }

    public static boolean isDriverAvailable(String driverName) {
        if (!GDALUtilities.isGDALAvailable()) {
            return false;
        }
        Driver driver = gdal.GetDriverByName((String)driverName);
        return driver != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DriverCreateCapabilities formatWritingCapabilities(String driverName) {
        if (driverName == null) {
            throw new IllegalArgumentException("The provided driver name is null");
        }
        GDALUtilities.loadGDAL();
        var1_1 = GDALUtilities.driversWritingCapabilities;
        synchronized (var1_1) {
            block20: {
                block17: {
                    block19: {
                        block16: {
                            block18: {
                                block15: {
                                    if (GDALUtilities.driversWritingCapabilities.containsKey(driverName)) {
                                        return GDALUtilities.driversWritingCapabilities.get(driverName);
                                    }
                                    driver = gdal.GetDriverByName((String)driverName);
                                    try {
                                        if (driver == null) {
                                            throw new IllegalArgumentException("A Driver with the specified name is unavailable. Check the specified name or be sure this Driver is supported");
                                        }
                                        metadata = driver.GetMetadata_Dict("");
                                        create = (String)metadata.get("DCAP_CREATE");
                                        createCopy = (String)metadata.get("DCAP_CREATECOPY");
                                        createSupported = create != null && create.equalsIgnoreCase("yes") != false;
                                        v0 = createCopySupported = createCopy != null && createCopy.equalsIgnoreCase("yes") != false;
                                        if (createSupported) {
                                            GDALUtilities.driversWritingCapabilities.put(driverName, DriverCreateCapabilities.CREATE);
                                            var9_8 = DriverCreateCapabilities.CREATE;
                                            var11_11 = null;
                                            if (driver == null) return var9_8;
                                            break block15;
                                        }
                                        if (createCopySupported) {
                                            GDALUtilities.driversWritingCapabilities.put(driverName, DriverCreateCapabilities.CREATE_COPY);
                                            var9_9 = DriverCreateCapabilities.CREATE_COPY;
                                            break block16;
                                        }
                                        GDALUtilities.driversWritingCapabilities.put(driverName, DriverCreateCapabilities.READ_ONLY);
                                        var9_10 = DriverCreateCapabilities.READ_ONLY;
                                        break block17;
                                    }
                                    catch (Throwable var10_19) {
                                        var11_14 = null;
                                        if (driver == null) throw var10_19;
                                        try {
                                            driver.delete();
                                            throw var10_19;
                                        }
                                        catch (Throwable e) {
                                            if (GDALUtilities.LOGGER.isLoggable(Level.FINEST) == false) throw var10_19;
                                            GDALUtilities.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                            throw var10_19;
                                        }
                                    }
                                }
                                ** try [egrp 3[TRYBLOCK] [4 : 248->255)] { 
lbl49:
                                // 1 sources

                                driver.delete();
                                break block18;
lbl51:
                                // 1 sources

                                catch (Throwable e) {
                                    if (GDALUtilities.LOGGER.isLoggable(Level.FINEST) == false) return var9_8;
                                    GDALUtilities.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                }
                            }
                            return var9_8;
                        }
                        var11_12 = null;
                        if (driver == null) return var9_9;
                        ** try [egrp 3[TRYBLOCK] [4 : 248->255)] { 
lbl60:
                        // 1 sources

                        driver.delete();
                        break block19;
lbl62:
                        // 1 sources

                        catch (Throwable e) {
                            if (GDALUtilities.LOGGER.isLoggable(Level.FINEST) == false) return var9_9;
                            GDALUtilities.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                        }
                    }
                    return var9_9;
                }
                var11_13 = null;
                if (driver == null) return var9_10;
                ** try [egrp 3[TRYBLOCK] [4 : 248->255)] { 
lbl71:
                // 1 sources

                driver.delete();
                break block20;
lbl73:
                // 1 sources

                catch (Throwable e) {
                    if (GDALUtilities.LOGGER.isLoggable(Level.FINEST) == false) return var9_10;
                    GDALUtilities.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                }
            }
            return var9_10;
        }
    }

    public static String getStreamMetadataItem(String metadataName, String datasetName) {
        return GDALUtilities.getMetadataItem(GDALUtilities.getGDALStreamMetadata(datasetName), metadataName);
    }

    public static String getMetadataItem(List imageMetadata, String metadataName) {
        for (String s : imageMetadata) {
            int indexOfEqualSymbol;
            String sName = s.substring(0, indexOfEqualSymbol = s.indexOf(61));
            if (!sName.equals(metadataName)) continue;
            return s.substring(indexOfEqualSymbol + 1, s.length());
        }
        return null;
    }

    public static List getGDALStreamMetadata(String datasetName) {
        Dataset ds = GDALUtilities.acquireDataSet(datasetName, gdalconst.GA_ReadOnly);
        Vector gdalStreamMetadata = ds.GetMetadata_List("SUBDATASETS");
        GDALUtilities.closeDataSet(ds);
        return gdalStreamMetadata;
    }

    public static void setNodeAttribute(String name, Object val, IIOMetadataNode node, int attributeType) {
        try {
            String value;
            if (val != null && val instanceof String && (value = (String)val) != null && value.length() > 0) {
                switch (attributeType) {
                    case 4: {
                        Double.parseDouble(value);
                        break;
                    }
                    case 3: {
                        Float.parseFloat(value);
                        break;
                    }
                    case 2: {
                        Integer.parseInt(value);
                        break;
                    }
                    case 1: {
                        Boolean.valueOf(value);
                        break;
                    }
                    case 0: {
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                node.setAttribute(name, value);
                return;
            }
        }
        catch (NumberFormatException nfe) {
            LOGGER.fine("The specified value has not been successfully parsed: " + (String)val);
        }
        node.setAttribute(name, "");
    }

    public static Dimension toTileSize(Dimension size) {
        Dimension defaultSize = JAI.getDefaultTileSize();
        if (defaultSize == null) {
            defaultSize = DEFAULT_TILE_SIZE;
        }
        size.height = defaultSize.height;
        size.width = defaultSize.width;
        return size;
    }

    public static boolean isGDALAvailable() {
        GDALUtilities.loadGDAL();
        return available;
    }

    public static synchronized void loadGDAL() {
        if (init) {
            return;
        }
        init = true;
        try {
            System.loadLibrary("gdaljni");
            gdal.AllRegister();
            String cplDebug = System.getProperty(CPL_DEBUG);
            boolean showErrors = GDALUtilities.getAsBoolean(cplDebug);
            if (!showErrors) {
                gdal.PushErrorHandler((String)"CPLQuietErrorHandler");
            }
            available = true;
        }
        catch (UnsatisfiedLinkError e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                StringBuilder sb = new StringBuilder("Failed to load the GDAL native libs. This is not a problem unless you need to use the GDAL plugins: they won't be enabled.").append(e.toString());
                LOGGER.warning(sb.toString());
            }
            available = false;
        }
    }

    public static ColorModel buildColorModel(SampleModel sampleModel) {
        ColorSpace cs = null;
        ColorModel colorModel = null;
        int buffer_type = sampleModel.getDataType();
        int numBands = sampleModel.getNumBands();
        if (numBands > 1) {
            colorModel = ImageUtil.createColorModel((SampleModel)sampleModel);
            if (colorModel == null) {
                LOGGER.severe("No ColorModels found");
            }
        } else if (buffer_type == 0 || buffer_type == 1 || buffer_type == 3 || buffer_type == 4 || buffer_type == 5) {
            cs = ColorSpace.getInstance(1003);
            colorModel = RasterFactory.createComponentColorModel((int)buffer_type, (ColorSpace)cs, (boolean)false, (boolean)false, (int)1);
        } else if (buffer_type == 2) {
            cs = ColorSpace.getInstance(1003);
            colorModel = new ComponentColorModel(cs, false, false, 1, 2);
        }
        return colorModel;
    }

    public static String buildCRSProperties(RenderedImage ri, int index) {
        Object imageReader = ri.getProperty("JAI.ImageReader");
        StringBuffer sb = new StringBuffer("CRS Information:").append(newLine);
        if (imageReader != null && imageReader instanceof ImageReader) {
            int gcpCount;
            double[] geoTransformations;
            GDALImageReader reader = (GDALImageReader)imageReader;
            String projection = reader.getProjection(index);
            if (!projection.equals("")) {
                sb.append("Projections:").append(projection).append(newLine);
            }
            if ((geoTransformations = reader.getGeoTransform(index)) != null) {
                sb.append("Geo Transformation:").append(newLine);
                sb.append("Origin = (").append(Double.toString(geoTransformations[0])).append(",").append(Double.toString(geoTransformations[3])).append(")").append(newLine).append("Pixel Size = (").append(Double.toString(geoTransformations[1])).append(",").append(Double.toString(geoTransformations[5])).append(")").append(newLine).append(newLine).append("---------- Affine GeoTransformation Coefficients ----------").append(newLine);
                for (int i = 0; i < 6; ++i) {
                    sb.append("adfTransformCoeff[").append(i).append("]=").append(Double.toString(geoTransformations[i])).append(newLine);
                }
            }
            if ((gcpCount = reader.getGCPCount(index)) != 0) {
                sb.append(newLine).append("Ground Control Points:").append(newLine).append("Projections:").append(newLine).append(reader.getGCPProjection(index)).append(newLine);
                List<? extends GCP> gcps = reader.getGCPs(index);
                int size = gcps.size();
                for (int i = 0; i < size; ++i) {
                    sb.append("GCP ").append(i + 1).append(gcps.get(i)).append(newLine);
                }
            }
        }
        return sb.toString();
    }

    public static String buildMetadataText(RenderedImage ri, MetadataChoice metadataFields, int index) {
        try {
            String newLine = System.getProperty("line.separator");
            Object imageReader = ri.getProperty("JAI.ImageReader");
            StringBuffer sb = new StringBuffer("");
            if (imageReader != null && imageReader instanceof ImageReader) {
                GDALImageReader reader = (GDALImageReader)imageReader;
                switch (metadataFields) {
                    case ONLY_IMAGE_METADATA: 
                    case EVERYTHING: {
                        sb.append(GDALUtilities.getImageMetadata(reader, index));
                        break;
                    }
                    case ONLY_STREAM_METADATA: {
                        sb.append(GDALUtilities.getStreamMetadata(reader));
                        break;
                    }
                    case STREAM_AND_IMAGE_METADATA: {
                        sb.append(GDALUtilities.getImageMetadata(reader, index)).append(newLine).append(GDALUtilities.getStreamMetadata(reader));
                    }
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning(e.getLocalizedMessage());
            }
            return "";
        }
    }

    public static String getImageMetadata(GDALImageReader reader, int index) {
        GDALCommonIIOImageMetadata mt = reader.getDatasetMetadata(index);
        List metadata = GDALUtilities.getGDALImageMetadata(mt.getDatasetName());
        if (metadata != null) {
            int size = metadata.size();
            StringBuffer sb = new StringBuffer("Image Metadata:").append(newLine);
            for (int i = 0; i < size; ++i) {
                sb.append(metadata.get(i)).append(newLine);
            }
            return sb.toString();
        }
        return "Image Metadata not found";
    }

    public static String getStreamMetadata(GDALImageReader reader) throws IOException {
        GDALCommonIIOImageMetadata mt = reader.getDatasetMetadata(reader.getNumImages(true) - 1);
        List metadata = GDALUtilities.getGDALStreamMetadata(mt.getDatasetName());
        if (metadata != null) {
            int size = metadata.size();
            StringBuffer sb = new StringBuffer("Stream Metadata:").append(newLine);
            for (int i = 0; i < size; ++i) {
                sb.append(metadata.get(i)).append(newLine);
            }
            return sb.toString();
        }
        return "Stream Metadata not found";
    }

    static {
        init = false;
        driversWritingCapabilities = Collections.synchronizedMap(new HashMap());
        DEFAULT_TILE_SIZE = new Dimension(512, 512);
        NEWLINE = System.getProperty("line.separator");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MetadataChoice {
        ONLY_IMAGE_METADATA,
        ONLY_STREAM_METADATA,
        STREAM_AND_IMAGE_METADATA,
        PROJECT_AND_GEOTRANSF,
        EVERYTHING;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DriverCreateCapabilities {
        CREATE,
        CREATE_COPY,
        READ_ONLY;

    }

    public static final class GDALMetadataDomain {
        public static final String IMAGESTRUCTURE = "IMAGE_STRUCTURE";
        public static final String SUBDATASETS = "SUBDATASETS";
        public static final String DEFAULT = "";
        protected static final String DEFAULT_KEY_MAP = "DEF";
        public static final String XML_PREFIX = "xml:";
    }
}

