/*
 * Decompiled with CFR 0.152.
 */
package ccl.servlet;

import ccl.servlet.HTML;
import ccl.servlet.XMLImportHandler;
import ccl.util.FileUtil;
import ccl.util.Util;
import http.utils.multipartrequest.ServletMultipartRequest;
import java.io.IOException;
import java.sql.Connection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class XMLImporter
extends HttpServlet {
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HTML html = new HTML(response);
        html.printTitle(this.getTitle());
        html.println("<form method=\"post\" enctype=\"multipart/form-data\" action=\"" + Util.getObjectName((Object)this) + "\">");
        html.println("Specify name of xml file to import:");
        html.println("<input type=\"file\" name=\"xmlfile\"><p>");
        html.println("<input type=\"submit\" name=\"Submit\">");
        html.println("</form>");
        html.close();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HTML html = new HTML(response);
        html.printTitle(this.getTitle());
        String sXMLFile = FileUtil.concatPath(FileUtil.getTempDir(), "xmlfile");
        ServletMultipartRequest multirequest = new ServletMultipartRequest(request, sXMLFile);
        Util.debug((Object)this, "doPost(..).file: " + sXMLFile);
        try {
            Connection connection = this.getConnection();
            XMLImportHandler.parse(connection, sXMLFile);
            connection.close();
        }
        catch (Exception exception) {
            Util.printlnErr(exception);
        }
        html.println("XML file was received successfully.");
        html.close();
    }

    public abstract Connection getConnection();

    public abstract String getTitle();
}

