/*
 * Decompiled with CFR 0.152.
 */
package ccl.swing;

import ccl.swing.AutoGridBagLayout;
import ccl.swing.ExitJDialog;
import ccl.swing.SwingUtil;
import ccl.util.Direction;
import ccl.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultFocusManager;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MessageBox
extends ExitJDialog
implements ActionListener {
    private JButton _btnOK = null;
    private FocusManager _fmOriginal = null;
    private static Font _pFont = new Font("Dialog", 1, 12);

    private static Font getLabelFont() {
        return _pFont;
    }

    public MessageBox(String sMessages_) {
        this(sMessages_, true);
    }

    public MessageBox(String sMessages_, boolean bModal_) {
        this(new Frame(), sMessages_, bModal_);
    }

    public MessageBox(Frame frmParent_, String sMessages_) {
        this(frmParent_, sMessages_, true, Direction.CENTER);
    }

    public MessageBox(Frame frmParent_, String sMessages_, boolean bModal_) {
        this(frmParent_, sMessages_, bModal_, Direction.CENTER);
    }

    public MessageBox(Frame frmParent_, String sMessages_, boolean bModal_, Direction dtnAlign_) {
        super(frmParent_, "Message", bModal_);
        Util.panicIf(sMessages_ == null);
        int align = 2;
        if (dtnAlign_ == Direction.CENTER) {
            align = 0;
        }
        if (dtnAlign_ == Direction.WEST) {
            align = 2;
        }
        if (dtnAlign_ == Direction.EAST) {
            align = 4;
        }
        Vector vMessages = Util.stringToLines(sMessages_);
        AutoGridBagLayout pAutoGridBagLayout = new AutoGridBagLayout();
        pAutoGridBagLayout.setInsets(7);
        this.getContentPane().setLayout(pAutoGridBagLayout);
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(20, 10, 10, 10));
        pAutoGridBagLayout.setExpandHorizontal();
        this.getContentPane().add(new JLabel(" "));
        pAutoGridBagLayout.endLine();
        int maxLength = 0;
        Enumeration e = vMessages.elements();
        while (e.hasMoreElements()) {
            String sLine = (String)e.nextElement();
            JLabel lblLine = new JLabel(sLine, align);
            lblLine.setFont(MessageBox.getLabelFont());
            this.getContentPane().add(lblLine);
            if (lblLine.getSize().width > maxLength) {
                maxLength = lblLine.getSize().width;
            }
            pAutoGridBagLayout.endLine();
        }
        this.getContentPane().add(new JLabel(" "));
        pAutoGridBagLayout.endLine();
        pAutoGridBagLayout.setExpandNone();
        this._btnOK = new JButton("OK");
        this._btnOK.setPreferredSize(new Dimension(75, this._btnOK.getPreferredSize().height));
        this._btnOK.addActionListener(this);
        this._btnOK.setFont(new Font("Dialog", 1, 12));
        this.getContentPane().add(this._btnOK);
        pAutoGridBagLayout.endLine();
        this.getContentPane().add(new JLabel(" "));
        pAutoGridBagLayout.endLine();
        Dimension dimSize = this.getSize();
        dimSize.height = (vMessages.size() + 2 + 2) * 23 + this.getInsets().top + this.getInsets().bottom;
        dimSize.width = maxLength + 80;
        int buttonWidth = this._btnOK.getMinimumSize().width + 40;
        if (dimSize.width < buttonWidth) {
            dimSize.width = buttonWidth;
        }
        Util.debug("MessageBox: <init> dimSize: " + dimSize);
        Dimension dimMax = SwingUtil.getScreenSize();
        ((Component)this).setSize(this.getPreferredSize().width + 20, this.getPreferredSize().height);
        SwingUtil.centerComponent(this);
        this.getRootPane().setDefaultButton(this._btnOK);
        this._fmOriginal = FocusManager.getCurrentManager();
        FocusManager.setCurrentManager(new LocalFocusManager());
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent pWindowEvent_) {
                MessageBox.this._btnOK.requestFocus();
            }
        });
    }

    public void setVisible(boolean bVisible_) {
        if (!bVisible_) {
            FocusManager.setCurrentManager(this._fmOriginal);
        }
        super.setVisible(bVisible_);
    }

    public void actionPerformed(ActionEvent pActionEvent_) {
        Object oSource = pActionEvent_.getSource();
        if (oSource instanceof JButton) {
            this.setVisible(false);
            if (!this.isModal()) {
                this.dispose();
            }
        }
    }

    public class LocalFocusManager
    extends DefaultFocusManager {
        public void processKeyEvent(Component cmpFocused_, KeyEvent pKeyEvent_) {
            if (pKeyEvent_.getKeyCode() == 27) {
                MessageBox.this.exit();
                return;
            }
        }
    }
}

