/*
 * Decompiled with CFR 0.152.
 */
package ccl.util;

import ccl.util.FileUtil;
import ccl.util.Util;
import java.io.ByteArrayInputStream;
import java.util.Hashtable;
import java.util.Properties;

public class SysEnv {
    public static final String S_SYS_ENV = "SYS_ENV";
    private static final char C_ENV_MARKER = '$';
    private static final char C_ENV_END_MARKER = ')';
    private static Properties _propApplicationEnv = null;

    public static void initialize() {
        String sPropFileName = System.getProperty(S_SYS_ENV);
        SysEnv.initialize(sPropFileName);
    }

    public static void initialize(String sPropFileName_) {
        if (Util.isEmpty(sPropFileName_) || !FileUtil.existsFile(sPropFileName_)) {
            Util.debug("ccl.util.SysEnv.initialize(..).NO_ENV_FILE");
            return;
        }
        try {
            String sEnvVarsFileContent = FileUtil.readFile(sPropFileName_);
            sEnvVarsFileContent = Util.replace(sEnvVarsFileContent, "\\", "\\\\");
            ByteArrayInputStream inputStream = new ByteArrayInputStream(sEnvVarsFileContent.getBytes());
            _propApplicationEnv = new Properties();
            _propApplicationEnv.load(inputStream);
            inputStream.close();
            Util.debug("ccl.util.SysEnv.init().Listing all the envoirnment properties");
            Util.debug("ccl.util.SysEnv.init()._propApplicationEnv: " + _propApplicationEnv.propertyNames().toString());
        }
        catch (Exception x) {
            Util.printlnErr("ccl.util.SysEnv.init().x: " + x.getMessage());
        }
    }

    public static boolean isEnvEvalReqd(String buffer) {
        Util.debug("isEnv=" + buffer);
        return buffer.indexOf("$") != -1;
    }

    public static String evalEnvVariable(String buffer) {
        try {
            Util.debug("ccl.util.SysEnv.evalEnvVariable(..).buffer: " + buffer);
            int start = SysEnv.getStartPos(buffer);
            Util.debug("ccl.util.SysEnv.evalEnvVariable(..).start: " + start);
            if (start == -1) {
                return buffer;
            }
            String var = SysEnv.getVariable(buffer, start);
            Util.debug("ccl.util.SysEnv.evalEnvVariable(..).var: " + var);
            int end = start + var.length() + 2;
            Util.debug("ccl.util.SysEnv.evalEnvVariable(..).end: " + end);
            String actualval = SysEnv.getActualVal(var);
            Util.debug("actualval" + actualval);
            String eval = SysEnv.replace(buffer, actualval, start, end);
            return SysEnv.isEnvEvalReqd(eval) ? SysEnv.evalEnvVariable(eval) : eval;
        }
        catch (Exception x) {
            Util.debug("SysEnv.evalEnvVariable(..).x: " + x);
            return buffer;
        }
    }

    private static int getStartPos(String buffer) {
        return buffer.indexOf(36);
    }

    private static String getVariable(String buffer, int start) throws Exception {
        int end = buffer.indexOf(41, start);
        if (end == -1) {
            throw new Exception("Env. eval failure: No ) for " + buffer + " after " + start);
        }
        return buffer.substring(start + 2, end);
    }

    private static String getActualVal(String val) {
        Util.debug("ccl.util.SysEnv.getActualVal(..).val: " + val);
        Util.debug("ccl.util.SysEnv.getActualVal(..)._propApplicationEnv: " + _propApplicationEnv);
        String s = (String)((Hashtable)_propApplicationEnv).get(val);
        if (s == null) {
            s = "";
        }
        return s;
    }

    private static String replace(String buffer, String actualval, int start, int end) {
        String pre = buffer.substring(0, start);
        String post = buffer.substring(end + 1, buffer.length());
        return pre + actualval + post;
    }
}

