/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqlx.io;

import com.google.protobuf.GeneratedMessage;
import com.mysql.cj.api.result.RowList;
import com.mysql.cj.api.x.SqlResult;
import com.mysql.cj.core.exceptions.CJCommunicationsException;
import com.mysql.cj.core.io.StatementExecuteOk;
import com.mysql.cj.core.result.Field;
import com.mysql.cj.mysqlx.MysqlxSession;
import com.mysql.cj.mysqlx.ResultCreatingResultListener;
import com.mysql.cj.mysqlx.devapi.SqlDataResult;
import com.mysql.cj.mysqlx.devapi.SqlUpdateResult;
import com.mysql.cj.mysqlx.io.AsyncMessageReader;
import com.mysql.cj.mysqlx.io.ResultMessageListener;
import com.mysql.cj.mysqlx.io.StatementExecuteOkMessageListener;
import com.mysql.cj.mysqlx.protobuf.Mysqlx;
import com.mysql.cj.mysqlx.protobuf.MysqlxResultset;
import java.util.ArrayList;
import java.util.TimeZone;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class SqlResultMessageListener
implements AsyncMessageReader.MessageListener {
    private ResultType resultType;
    private CompletableFuture<SqlResult> resultF;
    private StatementExecuteOkMessageListener okListener;
    private ResultMessageListener resultListener;
    private ResultCreatingResultListener<SqlResult> resultCreator;

    public SqlResultMessageListener(CompletableFuture<SqlResult> resultF, ResultMessageListener.ColToFieldTransformer colToField, TimeZone defaultTimeZone) {
        this.resultF = resultF;
        MysqlxSession.ResultCtor resultCtor = metadata -> (rows, task) -> new SqlDataResult((ArrayList<Field>)metadata, defaultTimeZone, (RowList)rows, (Supplier<StatementExecuteOk>)task);
        this.resultCreator = new ResultCreatingResultListener<SqlResult>(resultCtor, resultF);
        this.resultListener = new ResultMessageListener(colToField, this.resultCreator);
        CompletableFuture<StatementExecuteOk> okF = new CompletableFuture<StatementExecuteOk>();
        okF.whenComplete((ok, ex) -> {
            if (ex != null) {
                this.resultF.completeExceptionally((Throwable)ex);
            } else {
                this.resultF.complete(new SqlUpdateResult((StatementExecuteOk)ok));
            }
        });
        this.okListener = new StatementExecuteOkMessageListener(okF);
    }

    @Override
    public Boolean apply(Class<? extends GeneratedMessage> msgClass, GeneratedMessage msg) {
        if (this.resultType == null) {
            if (MysqlxResultset.ColumnMetaData.class.equals(msgClass)) {
                this.resultType = ResultType.DATA;
            } else if (!Mysqlx.Error.class.equals(msgClass)) {
                this.resultType = ResultType.UPDATE;
            }
        }
        if (this.resultType == ResultType.DATA) {
            return this.resultListener.apply(msgClass, msg);
        }
        return this.okListener.apply(msgClass, msg);
    }

    @Override
    public void closed() {
        this.resultF.completeExceptionally(new CJCommunicationsException("Sock was closed"));
    }

    @Override
    public void error(Throwable ex) {
        this.resultF.completeExceptionally(ex);
    }

    private static enum ResultType {
        UPDATE,
        DATA;

    }
}

