/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.Collector;
import net.bull.javamelody.CollectorController;
import net.bull.javamelody.CollectorServer;
import net.bull.javamelody.I18N;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class CollectorServlet
extends HttpServlet {
    private static final long serialVersionUID = -2070469677921953224L;
    private static final Logger LOGGER = Logger.getLogger((String)"javamelody");
    private Pattern allowedAddrPattern;
    private transient CollectorServer collectorServer;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        Parameters.initialize(config.getServletContext());
        if (!Boolean.parseBoolean(Parameters.getParameter(Parameter.LOG))) {
            LOGGER.setLevel(Level.WARN);
        }
        LOGGER.info((Object)"initialization of the collector servlet of the monitoring");
        if (Parameters.getParameter(Parameter.ALLOWED_ADDR_PATTERN) != null) {
            this.allowedAddrPattern = Pattern.compile(Parameters.getParameter(Parameter.ALLOWED_ADDR_PATTERN));
        }
        try {
            this.collectorServer = new CollectorServer();
        }
        catch (IOException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String application;
        CollectorController collectorController;
        long start;
        block10: {
            block9: {
                start = System.currentTimeMillis();
                if (this.isAddressNotAllowed(req)) {
                    LOGGER.info((Object)("Forbidden access to monitoring from " + req.getRemoteAddr()));
                    resp.sendError(403, "Forbidden access");
                    return;
                }
                collectorController = new CollectorController(this.collectorServer);
                application = collectorController.getApplication(req, resp);
                I18N.bindLocale(req.getLocale());
                try {
                    if (application != null) break block9;
                    CollectorController.writeOnlyAddApplication(resp);
                }
                catch (Throwable throwable) {
                    I18N.unbindLocale();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("monitoring from " + req.getRemoteAddr() + ", request=" + req.getRequestURI() + (req.getQueryString() != null ? '?' + req.getQueryString() : "") + ", application=" + application + " in " + (System.currentTimeMillis() - start) + "ms"));
                    }
                    throw throwable;
                }
                I18N.unbindLocale();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("monitoring from " + req.getRemoteAddr() + ", request=" + req.getRequestURI() + (req.getQueryString() != null ? '?' + req.getQueryString() : "") + ", application=" + application + " in " + (System.currentTimeMillis() - start) + "ms"));
                }
                return;
            }
            if (this.collectorServer.isApplicationDataAvailable(application)) break block10;
            resp.sendError(500, "Data unavailable for the application " + I18N.htmlEncode(application, false));
            I18N.unbindLocale();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("monitoring from " + req.getRemoteAddr() + ", request=" + req.getRequestURI() + (req.getQueryString() != null ? '?' + req.getQueryString() : "") + ", application=" + application + " in " + (System.currentTimeMillis() - start) + "ms"));
            }
            return;
        }
        collectorController.doMonitoring(req, resp, application);
        I18N.unbindLocale();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("monitoring from " + req.getRemoteAddr() + ", request=" + req.getRequestURI() + (req.getQueryString() != null ? '?' + req.getQueryString() : "") + ", application=" + application + " in " + (System.currentTimeMillis() - start) + "ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.isAddressNotAllowed(req)) {
            LOGGER.info((Object)("Forbidden access to monitoring from " + req.getRemoteAddr()));
            resp.sendError(403, "Forbidden access");
            return;
        }
        String appName = req.getParameter("appName");
        String appUrls = req.getParameter("appUrls");
        I18N.bindLocale(req.getLocale());
        CollectorController collectorController = new CollectorController(this.collectorServer);
        try {
            if (appName == null || appUrls == null) {
                this.writeMessage(req, resp, collectorController, I18N.getString("donnees_manquantes"));
                return;
            }
            if (!appUrls.startsWith("http://") && !appUrls.startsWith("https://")) {
                this.writeMessage(req, resp, collectorController, I18N.getString("urls_format"));
                return;
            }
            collectorController.addCollectorApplication(appName, appUrls);
            LOGGER.info((Object)("monitored application added: " + appName));
            LOGGER.info((Object)("urls of the monitored application: " + appUrls));
            CollectorController.showAlertAndRedirectTo(resp, I18N.getFormattedString("application_ajoutee", appName), "?application=" + appName);
        }
        catch (FileNotFoundException e) {
            String message = I18N.getString("monitoring_configure");
            LOGGER.warn((Object)message, (Throwable)e);
            this.writeMessage(req, resp, collectorController, message + '\n' + e.toString());
        }
        catch (StreamCorruptedException e) {
            String message = I18N.getFormattedString("reponse_non_comprise", appUrls);
            LOGGER.warn((Object)message, (Throwable)e);
            this.writeMessage(req, resp, collectorController, message + '\n' + e.toString());
        }
        catch (Exception e) {
            LOGGER.warn((Object)e.toString(), (Throwable)e);
            this.writeMessage(req, resp, collectorController, e.toString());
        }
        finally {
            I18N.unbindLocale();
        }
    }

    private void writeMessage(HttpServletRequest req, HttpServletResponse resp, CollectorController collectorController, String message) throws IOException {
        collectorController.writeMessage(req, resp, collectorController.getApplication(req, resp), message);
    }

    private boolean isAddressNotAllowed(HttpServletRequest req) {
        return this.allowedAddrPattern != null && !this.allowedAddrPattern.matcher(req.getRemoteAddr()).matches();
    }

    public void destroy() {
        LOGGER.info((Object)"collector servlet stopping");
        if (this.collectorServer != null) {
            this.collectorServer.stop();
        }
        Collector.stopJRobin();
        LOGGER.info((Object)"collector servlet stopped");
        super.destroy();
    }
}

