/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterRequest;
import net.bull.javamelody.CounterRequestContext;
import net.bull.javamelody.HtmlAbstractReport;
import net.bull.javamelody.HtmlCounterReport;
import net.bull.javamelody.HtmlThreadInformationsReport;
import net.bull.javamelody.I18N;
import net.bull.javamelody.PID;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.Period;
import net.bull.javamelody.ThreadInformations;

class HtmlCounterRequestContextReport
extends HtmlAbstractReport {
    private final List<CounterRequestContext> rootCurrentContexts;
    private final Map<String, HtmlCounterReport> counterReportsByCounterName;
    private final Map<Long, ThreadInformations> threadInformationsByThreadId;
    private final boolean childHitsDisplayed;
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();
    private final long timeOfSnapshot = System.currentTimeMillis();
    private final boolean stackTraceEnabled;
    private final int maxContextsDisplayed;
    private final boolean systemActionsEnabled = Parameters.isSystemActionsEnabled();
    private final HtmlThreadInformationsReport htmlThreadInformationsReport;

    HtmlCounterRequestContextReport(List<CounterRequestContext> rootCurrentContexts, Map<String, HtmlCounterReport> counterReportsByCounterName, List<ThreadInformations> threadInformationsList, boolean stackTraceEnabled, int maxContextsDisplayed, Writer writer) {
        super(writer);
        assert (rootCurrentContexts != null);
        assert (threadInformationsList != null);
        this.rootCurrentContexts = rootCurrentContexts;
        this.counterReportsByCounterName = counterReportsByCounterName == null ? new HashMap<String, HtmlCounterReport>() : counterReportsByCounterName;
        this.threadInformationsByThreadId = new HashMap<Long, ThreadInformations>(threadInformationsList.size());
        for (ThreadInformations threadInformations : threadInformationsList) {
            this.threadInformationsByThreadId.put(threadInformations.getId(), threadInformations);
        }
        boolean oneRootHasChild = false;
        for (CounterRequestContext rootCurrentContext : rootCurrentContexts) {
            if (!rootCurrentContext.hasChildHits()) continue;
            oneRootHasChild = true;
            break;
        }
        this.childHitsDisplayed = oneRootHasChild;
        this.htmlThreadInformationsReport = new HtmlThreadInformationsReport(threadInformationsList, stackTraceEnabled, writer);
        this.stackTraceEnabled = stackTraceEnabled;
        this.maxContextsDisplayed = maxContextsDisplayed;
    }

    @Override
    void toHtml() throws IOException {
        if (this.rootCurrentContexts.isEmpty()) {
            this.writeln("#Aucune_requete_en_cours#");
            return;
        }
        this.writeContexts(Collections.singletonList(this.rootCurrentContexts.get(0)));
        this.writeln("<div align='right'>");
        this.writeln(HtmlCounterRequestContextReport.getFormattedString("nb_requete_en_cours", this.integerFormat.format(this.rootCurrentContexts.size())));
        if (HtmlCounterRequestContextReport.isPdfEnabled()) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.write("<a href='?part=currentRequests&amp;format=pdf' title='#afficher_PDF#' class='noPrint'>");
            this.write("<img src='?resource=pdf.png' alt='#PDF#'/> #PDF#</a>");
        }
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        if (this.rootCurrentContexts.size() <= this.maxContextsDisplayed) {
            String counterName = this.rootCurrentContexts.get(0).getParentCounter().getName();
            this.writeShowHideLink("contextDetails" + counterName + PID.getPID(), "#Details#");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>");
            this.writeln("<div id='contextDetails" + counterName + PID.getPID() + "' style='display: none;'>");
            this.writeContexts(this.rootCurrentContexts);
            this.writeln("</div>");
        } else {
            this.writeln("<a href='?part=currentRequests'>#Details#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>");
        }
    }

    void writeTitleAndDetails() throws IOException {
        this.writeTitle("hourglass.png", HtmlCounterRequestContextReport.getString("Requetes_en_cours"));
        this.write("<br/>");
        if (this.rootCurrentContexts.isEmpty()) {
            this.writeln("#Aucune_requete_en_cours#");
            return;
        }
        this.writeContexts(this.rootCurrentContexts);
        this.writeln("<div align='right'>");
        this.writeln(HtmlCounterRequestContextReport.getFormattedString("nb_requete_en_cours", this.integerFormat.format(this.rootCurrentContexts.size())));
        this.writeln("</div>");
    }

    private void writeContexts(List<CounterRequestContext> contexts) throws IOException {
        boolean displayRemoteUser = false;
        for (CounterRequestContext context : contexts) {
            if (context.getRemoteUser() == null) continue;
            displayRemoteUser = true;
            break;
        }
        HtmlAbstractReport.HtmlTable table = new HtmlAbstractReport.HtmlTable();
        table.beginTable(HtmlCounterRequestContextReport.getString("Requetes_en_cours"));
        this.write("<th>#Thread#</th>");
        if (displayRemoteUser) {
            this.write("<th>#Utilisateur#</th>");
        }
        this.write("<th>#Requete#</th>");
        this.write("<th class='sorttable_numeric'>#Duree_ecoulee#</th><th class='sorttable_numeric'>#Temps_moyen#</th>");
        this.write("<th class='sorttable_numeric'>#Temps_cpu#</th><th class='sorttable_numeric'>#Temps_cpu_moyen#</th>");
        if (this.childHitsDisplayed) {
            String childCounterName = contexts.get(0).getParentCounter().getChildCounterName();
            this.write("<th class='sorttable_numeric'>" + HtmlCounterRequestContextReport.getFormattedString("hits_fils", childCounterName));
            this.write("</th><th class='sorttable_numeric'>" + HtmlCounterRequestContextReport.getFormattedString("hits_fils_moyens", childCounterName));
            this.write("</th><th class='sorttable_numeric'>" + HtmlCounterRequestContextReport.getFormattedString("temps_fils", childCounterName));
            this.write("</th><th class='sorttable_numeric'>" + HtmlCounterRequestContextReport.getFormattedString("temps_fils_moyen", childCounterName) + "</th>");
        }
        if (this.stackTraceEnabled) {
            this.write("<th>#Methode_executee#</th>");
        }
        if (this.systemActionsEnabled) {
            this.writeln("<th class='noPrint'>#Tuer#</th>");
        }
        for (CounterRequestContext context : contexts) {
            table.nextRow();
            this.writeContext(context, displayRemoteUser);
        }
        table.endTable();
    }

    private void writeContext(CounterRequestContext rootContext, boolean displayRemoteUser) throws IOException {
        ThreadInformations threadInformations = this.threadInformationsByThreadId.get(rootContext.getThreadId());
        this.write("<td valign='top'>");
        String espace = "&nbsp;";
        if (threadInformations == null) {
            this.write("&nbsp;");
        } else {
            this.htmlThreadInformationsReport.writeThreadWithStackTrace(threadInformations);
        }
        if (displayRemoteUser) {
            this.write("</td> <td valign='top'>");
            if (rootContext.getRemoteUser() == null) {
                this.write("&nbsp;");
            } else {
                this.write(rootContext.getRemoteUser());
            }
        }
        ArrayList<CounterRequestContext> contexts = new ArrayList<CounterRequestContext>(3);
        contexts.add(rootContext);
        contexts.addAll(rootContext.getChildContexts());
        CounterRequestContextReportHelper counterRequestContextReportHelper = new CounterRequestContextReportHelper(contexts, this.childHitsDisplayed);
        this.write("</td> <td>");
        this.writeRequests(contexts, counterRequestContextReportHelper);
        this.write("</td> <td align='right' valign='top'>");
        this.writeDurations(contexts);
        for (int[] requestValues : counterRequestContextReportHelper.getRequestValues()) {
            this.writeRequestValues(requestValues);
        }
        if (this.stackTraceEnabled) {
            this.write("</td> <td valign='top'>");
            if (threadInformations == null) {
                this.write("&nbsp;");
            } else {
                this.htmlThreadInformationsReport.writeExecutedMethod(threadInformations);
            }
        }
        if (threadInformations == null) {
            this.write("</td> <td class='noPrint'>");
            this.write("&nbsp;");
        } else {
            this.htmlThreadInformationsReport.writeKillThread(threadInformations);
        }
        this.write("</td>");
    }

    private void writeRequests(List<CounterRequestContext> contexts, CounterRequestContextReportHelper counterRequestContextReportHelper) throws IOException {
        int margin = 0;
        for (CounterRequestContext context : contexts) {
            this.write("<div style='margin-left: ");
            this.write(Integer.toString(margin));
            this.writeln("px;'>");
            this.writeRequest(context, counterRequestContextReportHelper);
            this.write("</div>");
            margin += 10;
        }
    }

    private void writeRequest(CounterRequestContext context, CounterRequestContextReportHelper counterRequestContextReportHelper) throws IOException {
        Counter parentCounter = context.getParentCounter();
        if (parentCounter.getIconName() != null) {
            this.write("<img src='?resource=");
            this.write(parentCounter.getIconName());
            this.write("' alt='");
            this.write(parentCounter.getName());
            this.write("' width='16' height='16' />&nbsp;");
        }
        HtmlCounterReport counterReport = this.getCounterReport(parentCounter, Period.TOUT);
        CounterRequest counterRequest = counterRequestContextReportHelper.getCounterRequest(context);
        counterReport.writeRequestName(counterRequest.getId(), context.getCompleteRequestName(), HtmlCounterReport.isRequestGraphDisplayed(parentCounter), true, false);
    }

    private HtmlCounterReport getCounterReport(Counter parentCounter, Period period) {
        HtmlCounterReport counterReport = this.counterReportsByCounterName.get(parentCounter.getName());
        if (counterReport == null) {
            counterReport = new HtmlCounterReport(parentCounter, period.getRange(), this.getWriter());
            this.counterReportsByCounterName.put(parentCounter.getName(), counterReport);
        }
        return counterReport;
    }

    private void writeDurations(List<CounterRequestContext> contexts) throws IOException {
        boolean first = true;
        for (CounterRequestContext context : contexts) {
            if (!first) {
                this.writeln("<br/>");
            }
            int duration = context.getDuration(this.timeOfSnapshot);
            Counter parentCounter = context.getParentCounter();
            if (parentCounter.getIconName() != null) {
                this.write("<img src='?resource=");
                this.write(parentCounter.getIconName());
                this.write("' alt='");
                this.write(parentCounter.getName());
                this.write("' width='16' height='16' />&nbsp;");
            }
            HtmlCounterReport counterReport = this.counterReportsByCounterName.get(parentCounter.getName());
            this.write("<span class='");
            this.write(counterReport.getSlaHtmlClass(duration));
            this.write("'>");
            this.write(this.integerFormat.format(duration));
            this.write("</span>");
            first = false;
        }
    }

    private void writeRequestValues(int[] requestValues) throws IOException {
        this.write("</td> <td align='right' valign='top'>");
        boolean first = true;
        for (int value : requestValues) {
            if (!first) {
                this.writeln("<br/>");
            }
            if (value == -1) {
                this.write("&nbsp;");
            } else {
                this.write(this.integerFormat.format(value));
            }
            first = false;
        }
    }

    static class CounterRequestContextReportHelper {
        private final List<CounterRequestContext> contexts;
        private final boolean childHitsDisplayed;
        private final Map<String, CounterRequest> counterRequestsByRequestName = new HashMap<String, CounterRequest>();

        CounterRequestContextReportHelper(List<CounterRequestContext> contexts, boolean childHitsDisplayed) {
            assert (contexts != null);
            this.contexts = contexts;
            this.childHitsDisplayed = childHitsDisplayed;
        }

        List<int[]> getRequestValues() {
            ArrayList<int[]> result = new ArrayList<int[]>();
            int contextsSize = this.contexts.size();
            int[] durationMeans = new int[contextsSize];
            int[] cpuTimes = new int[contextsSize];
            int[] cpuTimesMeans = new int[contextsSize];
            int i = 0;
            for (CounterRequestContext context : this.contexts) {
                CounterRequest counterRequest = this.getCounterRequest(context);
                durationMeans[i] = counterRequest.getMean();
                cpuTimesMeans[i] = counterRequest.getCpuTimeMean();
                cpuTimes[i] = cpuTimesMeans[i] >= 0 ? context.getCpuTime() : -1;
                ++i;
            }
            result.add(durationMeans);
            result.add(cpuTimes);
            result.add(cpuTimesMeans);
            if (this.childHitsDisplayed) {
                int[] totalChildHits = new int[contextsSize];
                int[] childHitsMeans = new int[contextsSize];
                int[] totalChildDurationsSum = new int[contextsSize];
                int[] childDurationsMeans = new int[contextsSize];
                i = 0;
                for (CounterRequestContext context : this.contexts) {
                    totalChildHits[i] = CounterRequestContextReportHelper.getValueOrIgnoreIfNoChildHitForContext(context, context.getTotalChildHits());
                    CounterRequest counterRequest = this.getCounterRequest(context);
                    childHitsMeans[i] = CounterRequestContextReportHelper.getValueOrIgnoreIfNoChildHitForContext(context, counterRequest.getChildHitsMean());
                    totalChildDurationsSum[i] = CounterRequestContextReportHelper.getValueOrIgnoreIfNoChildHitForContext(context, context.getTotalChildDurationsSum());
                    childDurationsMeans[i] = CounterRequestContextReportHelper.getValueOrIgnoreIfNoChildHitForContext(context, counterRequest.getChildDurationsMean());
                    ++i;
                }
                result.add(totalChildHits);
                result.add(childHitsMeans);
                result.add(totalChildDurationsSum);
                result.add(childDurationsMeans);
            }
            return result;
        }

        private static int getValueOrIgnoreIfNoChildHitForContext(CounterRequestContext context, int value) {
            if (context.getParentCounter().getChildCounterName() == null) {
                return -1;
            }
            return value;
        }

        CounterRequest getCounterRequest(CounterRequestContext context) {
            String requestName = context.getRequestName();
            CounterRequest counterRequest = this.counterRequestsByRequestName.get(requestName);
            if (counterRequest == null) {
                counterRequest = context.getParentCounter().getCounterRequest(context);
                this.counterRequestsByRequestName.put(requestName, counterRequest);
            }
            return counterRequest;
        }
    }
}

