/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.bull.javamelody.JndiBinding;
import net.bull.javamelody.PdfAbstractTableReport;
import net.bull.javamelody.PdfDocumentFactory;
import net.bull.javamelody.PdfFonts;

class PdfJndiReport
extends PdfAbstractTableReport {
    private final List<JndiBinding> jndiBindings;
    private final Font cellFont = PdfFonts.TABLE_CELL.getFont();
    private Image folderImage;

    PdfJndiReport(List<JndiBinding> jndiBindings, Document document) {
        super(document);
        assert (jndiBindings != null);
        this.jndiBindings = jndiBindings;
    }

    @Override
    void toPdf() throws DocumentException, IOException {
        this.writeHeader();
        for (JndiBinding jndiBinding : this.jndiBindings) {
            this.nextRow();
            this.writeJndiBinding(jndiBinding);
        }
        this.addTableToDocument();
    }

    private void writeHeader() throws DocumentException {
        List<String> headers = this.createHeaders();
        int[] relativeWidths = new int[headers.size()];
        Arrays.fill(relativeWidths, 0, headers.size(), 1);
        this.initTable(headers, relativeWidths);
    }

    private List<String> createHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(PdfJndiReport.getString("Nom"));
        headers.add(PdfJndiReport.getString("Type"));
        headers.add(PdfJndiReport.getString("Value"));
        return headers;
    }

    private void writeJndiBinding(JndiBinding jndiBinding) throws BadElementException, IOException {
        PdfPCell defaultCell = this.getDefaultCell();
        defaultCell.setHorizontalAlignment(0);
        String name = jndiBinding.getName();
        String className = jndiBinding.getClassName();
        String contextPath = jndiBinding.getContextPath();
        String value = jndiBinding.getValue();
        if (contextPath != null) {
            Image image = this.getFolderImage();
            Phrase phrase = new Phrase("", this.cellFont);
            phrase.add((Object)new Chunk(image, 0.0f, 0.0f));
            phrase.add((Object)" ");
            phrase.add((Object)name);
            this.addCell(phrase);
        } else {
            this.addCell(name);
        }
        this.addCell(className != null ? className : "");
        this.addCell(value != null ? value : "");
    }

    private Image getFolderImage() throws BadElementException, IOException {
        if (this.folderImage == null) {
            this.folderImage = PdfDocumentFactory.getImage("folder.png");
            this.folderImage.scalePercent(40.0f);
        }
        return this.folderImage;
    }
}

