/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.ops;

import java.util.ArrayList;
import java.util.Collection;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.ops.CASOperation;
import net.spy.memcached.ops.ConcatenationOperation;
import net.spy.memcached.ops.DeleteOperation;
import net.spy.memcached.ops.GetAndTouchOperation;
import net.spy.memcached.ops.GetOperation;
import net.spy.memcached.ops.GetsOperation;
import net.spy.memcached.ops.KeyedOperation;
import net.spy.memcached.ops.MutatorOperation;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.ReplicaGetOperation;
import net.spy.memcached.ops.ReplicaGetsOperation;
import net.spy.memcached.ops.StoreOperation;
import net.spy.memcached.ops.VBucketAware;

public abstract class BaseOperationFactory
implements OperationFactory {
    private String first(Collection<String> keys) {
        return keys.iterator().next();
    }

    @Override
    public Collection<Operation> clone(KeyedOperation op) {
        VBucketAware vop;
        OperationCallback callback;
        assert (op.getState() == OperationState.WRITE_QUEUED || op.getState() == OperationState.RETRY) : "Who passed me an operation in the " + (Object)((Object)op.getState()) + "state?";
        assert (!op.isCancelled()) : "Attempted to clone a canceled op";
        assert (!op.hasErrored()) : "Attempted to clone an errored op";
        ArrayList<Operation> rv = new ArrayList<Operation>(op.getKeys().size());
        if (op instanceof GetOperation) {
            rv.addAll(this.cloneGet(op));
        } else if (op instanceof ReplicaGetOperation) {
            rv.addAll(this.cloneGet(op));
        } else if (op instanceof ReplicaGetsOperation) {
            callback = (ReplicaGetsOperation.Callback)op.getCallback();
            for (String k : op.getKeys()) {
                rv.add(this.replicaGets(k, ((ReplicaGetsOperation)op).getReplicaIndex(), (ReplicaGetsOperation.Callback)callback));
            }
        } else if (op instanceof GetsOperation) {
            callback = (GetsOperation.Callback)op.getCallback();
            for (String k : op.getKeys()) {
                rv.add(this.gets(k, (GetsOperation.Callback)callback));
            }
        } else if (op instanceof CASOperation) {
            CASOperation cop = (CASOperation)op;
            rv.add(this.cas(cop.getStoreType(), this.first(op.getKeys()), cop.getCasValue(), cop.getFlags(), cop.getExpiration(), cop.getData(), (StoreOperation.Callback)cop.getCallback()));
        } else if (op instanceof DeleteOperation) {
            rv.add(this.delete(this.first(op.getKeys()), (DeleteOperation.Callback)op.getCallback()));
        } else if (op instanceof MutatorOperation) {
            MutatorOperation mo = (MutatorOperation)op;
            rv.add(this.mutate(mo.getType(), this.first(op.getKeys()), mo.getBy(), mo.getDefault(), mo.getExpiration(), op.getCallback()));
        } else if (op instanceof StoreOperation) {
            StoreOperation so = (StoreOperation)op;
            rv.add(this.store(so.getStoreType(), this.first(op.getKeys()), so.getFlags(), so.getExpiration(), so.getData(), (StoreOperation.Callback)op.getCallback()));
        } else if (op instanceof ConcatenationOperation) {
            ConcatenationOperation c = (ConcatenationOperation)op;
            rv.add(this.cat(c.getStoreType(), c.getCasValue(), this.first(op.getKeys()), c.getData(), c.getCallback()));
        } else if (op instanceof GetAndTouchOperation) {
            GetAndTouchOperation gt = (GetAndTouchOperation)op;
            rv.add(this.getAndTouch(this.first(gt.getKeys()), gt.getExpiration(), (GetAndTouchOperation.Callback)gt.getCallback()));
        } else assert (false) : "Unhandled operation type: " + op.getClass();
        if (op instanceof VBucketAware && !(vop = (VBucketAware)((Object)op)).getNotMyVbucketNodes().isEmpty()) {
            for (Operation operation : rv) {
                if (!(operation instanceof VBucketAware)) continue;
                Collection<MemcachedNode> notMyVbucketNodes = vop.getNotMyVbucketNodes();
                ((VBucketAware)((Object)operation)).setNotMyVbucketNodes(notMyVbucketNodes);
            }
        }
        return rv;
    }

    protected abstract Collection<? extends Operation> cloneGet(KeyedOperation var1);
}

