/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.HasRevision;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.event.EventHandler;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.MessageEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ProcessDefinitionImpl;

public abstract class EventSubscriptionEntity
implements PersistentObject,
HasRevision,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected int revision = 1;
    protected String eventType;
    protected String eventName;
    protected String executionId;
    protected String processInstanceId;
    protected String activityId;
    protected String configuration;
    protected Date created = Context.getProcessEngineConfiguration().getClock().getCurrentTime();
    protected String processDefinitionId;
    protected String tenantId;
    protected ExecutionEntity execution;
    protected ActivityImpl activity;

    public EventSubscriptionEntity() {
    }

    public EventSubscriptionEntity(ExecutionEntity executionEntity) {
        this();
        this.setExecution(executionEntity);
        this.setActivity(this.execution.getActivity());
        this.processInstanceId = executionEntity.getProcessInstanceId();
        this.processDefinitionId = executionEntity.getProcessDefinitionId();
    }

    public void eventReceived(Serializable payload, boolean processASync) {
        if (processASync) {
            this.scheduleEventAsync(payload);
        } else {
            this.processEventSync(payload);
        }
    }

    protected void processEventSync(Object payload) {
        EventHandler eventHandler = Context.getProcessEngineConfiguration().getEventHandler(this.eventType);
        if (eventHandler == null) {
            throw new ActivitiException("Could not find eventhandler for event of type '" + this.eventType + "'.");
        }
        eventHandler.handleEvent(this, payload, Context.getCommandContext());
    }

    protected void scheduleEventAsync(Serializable payload) {
        CommandContext commandContext = Context.getCommandContext();
        MessageEntity message = new MessageEntity();
        message.setJobHandlerType("event");
        message.setJobHandlerConfiguration(this.id);
        message.setTenantId(this.getTenantId());
        GregorianCalendar expireCal = new GregorianCalendar();
        ProcessEngineConfigurationImpl processEngineConfig = Context.getCommandContext().getProcessEngineConfiguration();
        expireCal.setTime(processEngineConfig.getClock().getCurrentTime());
        expireCal.add(13, processEngineConfig.getLockTimeAsyncJobWaitTime());
        message.setLockExpirationTime(expireCal.getTime());
        commandContext.getJobEntityManager().send(message);
    }

    public void delete() {
        Context.getCommandContext().getEventSubscriptionEntityManager().deleteEventSubscription(this);
        this.removeFromExecution();
    }

    public void insert() {
        Context.getCommandContext().getEventSubscriptionEntityManager().insert(this);
        this.addToExecution();
    }

    protected void addToExecution() {
        ExecutionEntity execution = this.getExecution();
        if (execution != null) {
            execution.addEventSubscription(this);
        }
    }

    protected void removeFromExecution() {
        ExecutionEntity execution = this.getExecution();
        if (execution != null) {
            execution.removeEventSubscription(this);
        }
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, String> persistentState = new HashMap<String, String>();
        persistentState.put("executionId", this.executionId);
        persistentState.put("configuration", this.configuration);
        persistentState.put("processDefinitionId", this.processDefinitionId);
        return persistentState;
    }

    public ExecutionEntity getExecution() {
        if (this.execution == null && this.executionId != null) {
            this.execution = Context.getCommandContext().getExecutionEntityManager().findExecutionById(this.executionId);
        }
        return this.execution;
    }

    public void setExecution(ExecutionEntity execution) {
        this.execution = execution;
        if (execution != null) {
            this.executionId = execution.getId();
        }
    }

    public ActivityImpl getActivity() {
        ExecutionEntity execution;
        if (this.activity == null && this.activityId != null && (execution = this.getExecution()) != null) {
            ProcessDefinitionImpl processDefinition = execution.getProcessDefinition();
            this.activity = processDefinition.findActivity(this.activityId);
        }
        return this.activity;
    }

    public void setActivity(ActivityImpl activity) {
        this.activity = activity;
        if (activity != null) {
            this.activityId = activity.getId();
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventSubscriptionEntity other = (EventSubscriptionEntity)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

