/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.jar;

import java.io.IOException;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.jar.JarFileSystem;
import org.apache.commons.vfs2.provider.zip.ZipFileObject;

public class JarFileObject
extends ZipFileObject {
    private final JarFileSystem fs;
    private Attributes attributes;

    protected JarFileObject(AbstractFileName name, ZipEntry entry, JarFileSystem fs, boolean zipExists) throws FileSystemException {
        super(name, entry, fs, zipExists);
        this.fs = fs;
        try {
            this.getAttributes();
        }
        catch (IOException e) {
            throw new FileSystemException(e);
        }
    }

    Manifest getManifest() throws IOException {
        if (this.fs.getZipFile() == null) {
            return null;
        }
        return ((JarFile)this.fs.getZipFile()).getManifest();
    }

    Attributes getAttributes() throws IOException {
        if (this.attributes == null) {
            if (this.entry == null) {
                this.attributes = new Attributes(1);
            } else {
                this.attributes = ((JarEntry)this.entry).getAttributes();
                if (this.attributes == null) {
                    this.attributes = new Attributes(1);
                }
            }
        }
        return this.attributes;
    }

    @Override
    protected Map<String, Object> doGetAttributes() throws Exception {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        JarFileSystem fs = (JarFileSystem)this.getFileSystem();
        this.addAll(fs.getAttributes(), attrs);
        this.addAll(this.getAttributes(), attrs);
        return attrs;
    }

    private void addAll(Attributes src, Map<String, Object> dest) {
        for (Map.Entry<Object, Object> entry : src.entrySet()) {
            String name = entry.getKey().toString();
            dest.put(name, entry.getValue());
        }
    }

    @Override
    protected Certificate[] doGetCertificates() {
        if (this.entry == null) {
            return null;
        }
        return ((JarEntry)this.entry).getCertificates();
    }
}

