/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo3d;

import org.apache.lucene.geo3d.Bounds;
import org.apache.lucene.geo3d.DistanceStyle;
import org.apache.lucene.geo3d.GeoBBox;
import org.apache.lucene.geo3d.GeoBBoxFactory;
import org.apache.lucene.geo3d.GeoBaseBBox;
import org.apache.lucene.geo3d.GeoPoint;
import org.apache.lucene.geo3d.GeoShape;
import org.apache.lucene.geo3d.Membership;
import org.apache.lucene.geo3d.Plane;
import org.apache.lucene.geo3d.PlanetModel;
import org.apache.lucene.geo3d.SidedPlane;
import org.apache.lucene.geo3d.Vector;

public class GeoWideRectangle
extends GeoBaseBBox {
    protected final double topLat;
    protected final double bottomLat;
    protected final double leftLon;
    protected final double rightLon;
    protected final double cosMiddleLat;
    protected final GeoPoint ULHC;
    protected final GeoPoint URHC;
    protected final GeoPoint LRHC;
    protected final GeoPoint LLHC;
    protected final SidedPlane topPlane;
    protected final SidedPlane bottomPlane;
    protected final SidedPlane leftPlane;
    protected final SidedPlane rightPlane;
    protected final GeoPoint[] topPlanePoints;
    protected final GeoPoint[] bottomPlanePoints;
    protected final GeoPoint[] leftPlanePoints;
    protected final GeoPoint[] rightPlanePoints;
    protected final GeoPoint centerPoint;
    protected final EitherBound eitherBound;
    protected final GeoPoint[] edgePoints;

    public GeoWideRectangle(PlanetModel planetModel, double topLat, double bottomLat, double leftLon, double rightLon) {
        super(planetModel);
        if (topLat > 1.5707963267948966 || topLat < -1.5707963267948966) {
            throw new IllegalArgumentException("Top latitude out of range");
        }
        if (bottomLat > 1.5707963267948966 || bottomLat < -1.5707963267948966) {
            throw new IllegalArgumentException("Bottom latitude out of range");
        }
        if (topLat < bottomLat) {
            throw new IllegalArgumentException("Top latitude less than bottom latitude");
        }
        if (leftLon < -Math.PI || leftLon > Math.PI) {
            throw new IllegalArgumentException("Left longitude out of range");
        }
        if (rightLon < -Math.PI || rightLon > Math.PI) {
            throw new IllegalArgumentException("Right longitude out of range");
        }
        double extent = rightLon - leftLon;
        if (extent < 0.0) {
            extent += Math.PI * 2;
        }
        if (extent < Math.PI) {
            throw new IllegalArgumentException("Width of rectangle too small");
        }
        this.topLat = topLat;
        this.bottomLat = bottomLat;
        this.leftLon = leftLon;
        this.rightLon = rightLon;
        double sinTopLat = Math.sin(topLat);
        double cosTopLat = Math.cos(topLat);
        double sinBottomLat = Math.sin(bottomLat);
        double cosBottomLat = Math.cos(bottomLat);
        double sinLeftLon = Math.sin(leftLon);
        double cosLeftLon = Math.cos(leftLon);
        double sinRightLon = Math.sin(rightLon);
        double cosRightLon = Math.cos(rightLon);
        this.ULHC = new GeoPoint(planetModel, sinTopLat, sinLeftLon, cosTopLat, cosLeftLon, topLat, leftLon);
        this.URHC = new GeoPoint(planetModel, sinTopLat, sinRightLon, cosTopLat, cosRightLon, topLat, rightLon);
        this.LRHC = new GeoPoint(planetModel, sinBottomLat, sinRightLon, cosBottomLat, cosRightLon, bottomLat, rightLon);
        this.LLHC = new GeoPoint(planetModel, sinBottomLat, sinLeftLon, cosBottomLat, cosLeftLon, bottomLat, leftLon);
        double middleLat = (topLat + bottomLat) * 0.5;
        double sinMiddleLat = Math.sin(middleLat);
        this.cosMiddleLat = Math.cos(middleLat);
        while (leftLon > rightLon) {
            rightLon += Math.PI * 2;
        }
        double middleLon = (leftLon + rightLon) * 0.5;
        double sinMiddleLon = Math.sin(middleLon);
        double cosMiddleLon = Math.cos(middleLon);
        this.centerPoint = new GeoPoint(planetModel, sinMiddleLat, sinMiddleLon, this.cosMiddleLat, cosMiddleLon);
        this.topPlane = new SidedPlane((Vector)this.centerPoint, planetModel, sinTopLat);
        this.bottomPlane = new SidedPlane((Vector)this.centerPoint, planetModel, sinBottomLat);
        this.leftPlane = new SidedPlane((Vector)this.centerPoint, cosLeftLon, sinLeftLon);
        this.rightPlane = new SidedPlane((Vector)this.centerPoint, cosRightLon, sinRightLon);
        this.topPlanePoints = new GeoPoint[]{this.ULHC, this.URHC};
        this.bottomPlanePoints = new GeoPoint[]{this.LLHC, this.LRHC};
        this.leftPlanePoints = new GeoPoint[]{this.ULHC, this.LLHC};
        this.rightPlanePoints = new GeoPoint[]{this.URHC, this.LRHC};
        this.eitherBound = new EitherBound();
        this.edgePoints = new GeoPoint[]{this.ULHC};
    }

    @Override
    public GeoBBox expand(double angle) {
        double newTopLat = this.topLat + angle;
        double newBottomLat = this.bottomLat - angle;
        double currentLonSpan = this.rightLon - this.leftLon;
        if (currentLonSpan < 0.0) {
            currentLonSpan += Math.PI * 2;
        }
        double newLeftLon = this.leftLon - angle;
        double newRightLon = this.rightLon + angle;
        if (currentLonSpan + 2.0 * angle >= Math.PI * 2) {
            newLeftLon = -Math.PI;
            newRightLon = Math.PI;
        }
        return GeoBBoxFactory.makeGeoBBox(this.planetModel, newTopLat, newBottomLat, newLeftLon, newRightLon);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return this.topPlane.isWithin(x, y, z) && this.bottomPlane.isWithin(x, y, z) && (this.leftPlane.isWithin(x, y, z) || this.rightPlane.isWithin(x, y, z));
    }

    @Override
    public double getRadius() {
        double centerAngle = (this.rightLon - (this.rightLon + this.leftLon) * 0.5) * this.cosMiddleLat;
        double topAngle = this.centerPoint.arcDistance(this.URHC);
        double bottomAngle = this.centerPoint.arcDistance(this.LLHC);
        return Math.max(centerAngle, Math.max(topAngle, bottomAngle));
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public GeoPoint getCenter() {
        return this.centerPoint;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        return p.intersects(this.planetModel, this.topPlane, notablePoints, this.topPlanePoints, bounds, this.bottomPlane, this.eitherBound) || p.intersects(this.planetModel, this.bottomPlane, notablePoints, this.bottomPlanePoints, bounds, this.topPlane, this.eitherBound) || p.intersects(this.planetModel, this.leftPlane, notablePoints, this.leftPlanePoints, bounds, this.topPlane, this.bottomPlane) || p.intersects(this.planetModel, this.rightPlane, notablePoints, this.rightPlanePoints, bounds, this.topPlane, this.bottomPlane);
    }

    @Override
    public void getBounds(Bounds bounds) {
        super.getBounds(bounds);
        bounds.isWide().addHorizontalPlane(this.planetModel, this.topLat, this.topPlane, this.bottomPlane, this.eitherBound).addVerticalPlane(this.planetModel, this.rightLon, this.rightPlane, this.topPlane, this.bottomPlane).addHorizontalPlane(this.planetModel, this.bottomLat, this.bottomPlane, this.topPlane, this.eitherBound).addVerticalPlane(this.planetModel, this.leftLon, this.leftPlane, this.topPlane, this.bottomPlane).addPoint(this.ULHC).addPoint(this.URHC).addPoint(this.LRHC).addPoint(this.LLHC);
    }

    @Override
    public int getRelationship(GeoShape path) {
        int insideRectangle = this.isShapeInsideBBox(path);
        if (insideRectangle == 1) {
            return 2;
        }
        boolean insideShape = path.isWithin(this.ULHC);
        if (insideRectangle == 0 && insideShape) {
            return 2;
        }
        if (path.intersects(this.topPlane, this.topPlanePoints, this.bottomPlane, this.eitherBound) || path.intersects(this.bottomPlane, this.bottomPlanePoints, this.topPlane, this.eitherBound) || path.intersects(this.leftPlane, this.leftPlanePoints, this.topPlane, this.bottomPlane) || path.intersects(this.rightPlane, this.rightPlanePoints, this.topPlane, this.bottomPlane)) {
            return 2;
        }
        if (insideRectangle == 0) {
            return 1;
        }
        if (insideShape) {
            return 0;
        }
        return 3;
    }

    @Override
    protected double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        double topDistance = distanceStyle.computeDistance(this.planetModel, (Plane)this.topPlane, x, y, z, this.bottomPlane, this.eitherBound);
        double bottomDistance = distanceStyle.computeDistance(this.planetModel, (Plane)this.bottomPlane, x, y, z, this.topPlane, this.eitherBound);
        double leftDistance = distanceStyle.computeDistance(this.planetModel, (Plane)this.leftPlane, x, y, z, this.topPlane, this.bottomPlane);
        double rightDistance = distanceStyle.computeDistance(this.planetModel, (Plane)this.rightPlane, x, y, z, this.topPlane, this.bottomPlane);
        double ULHCDistance = distanceStyle.computeDistance(this.ULHC, x, y, z);
        double URHCDistance = distanceStyle.computeDistance(this.URHC, x, y, z);
        double LRHCDistance = distanceStyle.computeDistance(this.LRHC, x, y, z);
        double LLHCDistance = distanceStyle.computeDistance(this.LLHC, x, y, z);
        return Math.min(Math.min(Math.min(topDistance, bottomDistance), Math.min(leftDistance, rightDistance)), Math.min(Math.min(ULHCDistance, URHCDistance), Math.min(LRHCDistance, LLHCDistance)));
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoWideRectangle)) {
            return false;
        }
        GeoWideRectangle other = (GeoWideRectangle)o;
        return super.equals(other) && other.ULHC.equals(this.ULHC) && other.LRHC.equals(this.LRHC);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.ULHC.hashCode();
        result = 31 * result + this.LRHC.hashCode();
        return result;
    }

    public String toString() {
        return "GeoWideRectangle: {planetmodel=" + this.planetModel + ", toplat=" + this.topLat + "(" + this.topLat * 180.0 / Math.PI + "), bottomlat=" + this.bottomLat + "(" + this.bottomLat * 180.0 / Math.PI + "), leftlon=" + this.leftLon + "(" + this.leftLon * 180.0 / Math.PI + "), rightlon=" + this.rightLon + "(" + this.rightLon * 180.0 / Math.PI + ")}";
    }

    protected class EitherBound
    implements Membership {
        @Override
        public boolean isWithin(Vector v) {
            return GeoWideRectangle.this.leftPlane.isWithin(v) || GeoWideRectangle.this.rightPlane.isWithin(v);
        }

        @Override
        public boolean isWithin(double x, double y, double z) {
            return GeoWideRectangle.this.leftPlane.isWithin(x, y, z) || GeoWideRectangle.this.rightPlane.isWithin(x, y, z);
        }
    }
}

