/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.enforcer.rule.api.AbstractEnforcerRule;
import org.apache.maven.enforcer.rule.api.AbstractEnforcerRuleConfigProvider;
import org.apache.maven.enforcer.rule.api.EnforcerLevel;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleError;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.enforcer.internal.DefaultEnforcementRuleHelper;
import org.apache.maven.plugins.enforcer.internal.EnforcerRuleCache;
import org.apache.maven.plugins.enforcer.internal.EnforcerRuleDesc;
import org.apache.maven.plugins.enforcer.internal.EnforcerRuleManager;
import org.apache.maven.plugins.enforcer.internal.EnforcerRuleManagerException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.DefaultPlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="enforce", defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyCollection=ResolutionScope.TEST, threadSafe=true)
public class EnforceMojo
extends AbstractMojo {
    protected static Hashtable<String, EnforcerRule> cache = new Hashtable();
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    protected MojoExecution mojoExecution;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="enforcer.skip", defaultValue="false")
    protected boolean skip = false;
    @Parameter(property="enforcer.fail", defaultValue="true")
    private boolean fail = true;
    @Parameter(property="enforcer.failFast", defaultValue="false")
    private boolean failFast = false;
    @Parameter(property="enforcer.failIfNoRules", defaultValue="true")
    private boolean failIfNoRules = true;
    @Parameter
    private PlexusConfiguration rules;
    @Parameter(required=false, property="enforcer.skipRules")
    private List<String> rulesToSkip;
    @Parameter(property="enforcer.ignoreCache", defaultValue="false")
    protected boolean ignoreCache = false;
    @Component
    private PlexusContainer container;
    @Component
    private EnforcerRuleManager enforcerRuleManager;
    @Component
    private EnforcerRuleCache ruleCache;
    private List<String> rulesToExecute;

    @Parameter(required=false, property="enforcer.rules")
    public void setRulesToExecute(List<String> rulesToExecute) throws MojoExecutionException {
        if (rulesToExecute != null && !rulesToExecute.isEmpty()) {
            if (this.rulesToExecute != null && !this.rulesToExecute.isEmpty()) {
                throw new MojoExecutionException("Detected the usage of both '-Drules' (which is deprecated) and '-Denforcer.rules'. Please use only one of them, preferably '-Denforcer.rules'.");
            }
            this.rulesToExecute = rulesToExecute;
        }
    }

    @Deprecated
    @Parameter(required=false, property="rules")
    public void setCommandLineRules(List<String> rulesToExecute) throws MojoExecutionException {
        if (rulesToExecute != null && !rulesToExecute.isEmpty()) {
            this.getLog().warn((CharSequence)"Detected the usage of property '-Drules' which is deprecated. Use '-Denforcer.rules' instead.");
        }
        this.setRulesToExecute(rulesToExecute);
    }

    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        if (this.skip) {
            log.info((CharSequence)"Skipping Rule Enforcement.");
            return;
        }
        Optional<PlexusConfiguration> rulesFromCommandLine = this.createRulesFromCommandLineOptions();
        List<EnforcerRuleDesc> allRules = this.enforcerRuleManager.createRules(rulesFromCommandLine.orElse(this.rules), log);
        List<EnforcerRuleDesc> rulesList = this.filterOutSkippedRules(allRules);
        List<EnforcerRuleDesc> additionalRules = this.processRuleConfigProviders(rulesList);
        rulesList = this.filterOutRuleConfigProviders(rulesList);
        rulesList.addAll(additionalRules);
        if (rulesList.isEmpty()) {
            if (this.failIfNoRules) {
                throw new MojoExecutionException("No rules are configured. Use the skip flag if you want to disable execution.");
            }
            log.warn((CharSequence)"No rules are configured.");
            return;
        }
        PluginParameterExpressionEvaluator evaluator = new PluginParameterExpressionEvaluator(this.session, this.mojoExecution);
        DefaultEnforcementRuleHelper helper = new DefaultEnforcementRuleHelper(this.session, (ExpressionEvaluator)evaluator, log, this.container);
        if (!this.fail) {
            this.failFast = false;
        }
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (int ruleIndex = 0; ruleIndex < rulesList.size(); ++ruleIndex) {
            String ruleMessage;
            EnforcerRuleDesc ruleDesc = rulesList.get(ruleIndex);
            EnforcerLevel level = ruleDesc.getLevel();
            try {
                this.executeRule(ruleIndex, ruleDesc, helper);
                continue;
            }
            catch (EnforcerRuleError e) {
                ruleMessage = this.createRuleMessage(ruleIndex, ruleDesc, EnforcerLevel.ERROR, (EnforcerRuleException)((Object)e));
                throw new MojoExecutionException(System.lineSeparator() + ruleMessage, (Exception)((Object)e));
            }
            catch (EnforcerRuleException e) {
                ruleMessage = this.createRuleMessage(ruleIndex, ruleDesc, level, e);
                if (this.failFast && level == EnforcerLevel.ERROR) {
                    throw new MojoExecutionException(System.lineSeparator() + ruleMessage, (Exception)((Object)e));
                }
                if (level == EnforcerLevel.ERROR) {
                    errorMessages.add(ruleMessage);
                    continue;
                }
                log.warn((CharSequence)ruleMessage);
            }
        }
        if (!errorMessages.isEmpty()) {
            if (this.fail) {
                throw new MojoExecutionException(System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), errorMessages));
            }
            errorMessages.forEach(arg_0 -> ((Log)log).warn(arg_0));
        }
    }

    private List<EnforcerRuleDesc> processRuleConfigProviders(List<EnforcerRuleDesc> rulesList) {
        return rulesList.stream().filter(Objects::nonNull).filter(rd -> rd.getRule() instanceof AbstractEnforcerRuleConfigProvider).map(this::executeRuleConfigProvider).flatMap(xml -> this.enforcerRuleManager.createRules((PlexusConfiguration)xml, this.getLog()).stream()).collect(Collectors.toList());
    }

    private List<EnforcerRuleDesc> filterOutRuleConfigProviders(List<EnforcerRuleDesc> rulesList) {
        return rulesList.stream().filter(Objects::nonNull).filter(rd -> !(rd.getRule() instanceof AbstractEnforcerRuleConfigProvider)).collect(Collectors.toList());
    }

    private XmlPlexusConfiguration executeRuleConfigProvider(EnforcerRuleDesc ruleDesc) {
        AbstractEnforcerRuleConfigProvider ruleProducer = (AbstractEnforcerRuleConfigProvider)ruleDesc.getRule();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format("Executing Rule Config Provider %s", ruleDesc.getRule()));
        }
        XmlPlexusConfiguration configuration = null;
        try {
            configuration = new XmlPlexusConfiguration(ruleProducer.getRulesConfig());
        }
        catch (EnforcerRuleException e) {
            throw new EnforcerRuleManagerException("Rules Provider error for: " + this.getRuleName(ruleDesc), e);
        }
        this.getLog().info((CharSequence)String.format("Rule Config Provider %s executed", this.getRuleName(ruleDesc)));
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRule(int ruleIndex, EnforcerRuleDesc ruleDesc, EnforcerRuleHelper helper) throws EnforcerRuleException {
        long startTime;
        block6: {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)String.format("Executing Rule %d: %s", ruleIndex, ruleDesc));
            }
            startTime = System.currentTimeMillis();
            try {
                if (ruleDesc.getRule() instanceof EnforcerRule) {
                    this.executeRuleOld(ruleIndex, ruleDesc, helper);
                    break block6;
                }
                if (!(ruleDesc.getRule() instanceof AbstractEnforcerRule)) break block6;
                this.executeRuleNew(ruleIndex, ruleDesc);
            }
            catch (Throwable throwable) {
                if (this.getLog().isDebugEnabled()) {
                    long workTime = System.currentTimeMillis() - startTime;
                    this.getLog().debug((CharSequence)String.format("Finish Rule %d: %s takes %d ms", ruleIndex, this.getRuleName(ruleDesc), workTime));
                }
                throw throwable;
            }
        }
        if (this.getLog().isDebugEnabled()) {
            long workTime = System.currentTimeMillis() - startTime;
            this.getLog().debug((CharSequence)String.format("Finish Rule %d: %s takes %d ms", ruleIndex, this.getRuleName(ruleDesc), workTime));
        }
    }

    private void executeRuleOld(int ruleIndex, EnforcerRuleDesc ruleDesc, EnforcerRuleHelper helper) throws EnforcerRuleException {
        EnforcerRule rule = (EnforcerRule)ruleDesc.getRule();
        if (this.ignoreCache || this.shouldExecute(rule)) {
            rule.execute(helper);
            this.getLog().info((CharSequence)String.format("Rule %d: %s passed", ruleIndex, this.getRuleName(ruleDesc)));
        }
    }

    private void executeRuleNew(int ruleIndex, EnforcerRuleDesc ruleDesc) throws EnforcerRuleException {
        AbstractEnforcerRule rule = (AbstractEnforcerRule)ruleDesc.getRule();
        if (this.ignoreCache || !this.ruleCache.isCached(rule)) {
            rule.execute();
            this.getLog().info((CharSequence)String.format("Rule %d: %s passed", ruleIndex, this.getRuleName(ruleDesc)));
        }
    }

    private Optional<PlexusConfiguration> createRulesFromCommandLineOptions() {
        if (this.rulesToExecute == null || this.rulesToExecute.isEmpty()) {
            return Optional.empty();
        }
        DefaultPlexusConfiguration configuration = new DefaultPlexusConfiguration("rules");
        for (String rule : this.rulesToExecute) {
            configuration.addChild((PlexusConfiguration)new DefaultPlexusConfiguration(rule));
        }
        return Optional.of(configuration);
    }

    private List<EnforcerRuleDesc> filterOutSkippedRules(List<EnforcerRuleDesc> allRules) {
        if (this.rulesToSkip == null || this.rulesToSkip.isEmpty()) {
            return allRules;
        }
        return allRules.stream().filter(ruleDesc -> !this.rulesToSkip.contains(ruleDesc.getName())).collect(Collectors.toList());
    }

    protected boolean shouldExecute(EnforcerRule rule) {
        if (rule.isCacheable()) {
            Log log = this.getLog();
            log.debug((CharSequence)("Rule " + rule.getClass().getName() + " is cacheable."));
            String key = rule.getClass().getName() + " " + rule.getCacheId();
            if (cache.containsKey(key)) {
                log.debug((CharSequence)("Key " + key + " was found in the cache"));
                if (rule.isResultValid(cache.get(key))) {
                    log.debug((CharSequence)("The cached results are still valid. Skipping the rule: " + rule.getClass().getName()));
                    return false;
                }
            }
            cache.put(key, rule);
        }
        return true;
    }

    public void setRulesToSkip(List<String> rulesToSkip) {
        if (rulesToSkip == null) {
            return;
        }
        this.rulesToSkip = rulesToSkip.stream().filter(Objects::nonNull).map(StringUtils::lowercaseFirstLetter).collect(Collectors.toList());
    }

    public void setFail(boolean theFail) {
        this.fail = theFail;
    }

    public void setFailFast(boolean theFailFast) {
        this.failFast = theFailFast;
    }

    private String createRuleMessage(int ruleIndex, EnforcerRuleDesc ruleDesc, EnforcerLevel level, EnforcerRuleException e) {
        StringBuilder result = new StringBuilder();
        result.append("Rule ").append(ruleIndex).append(": ").append(this.getRuleName(ruleDesc));
        if (level == EnforcerLevel.ERROR) {
            result.append(" failed");
        } else {
            result.append(" warned");
        }
        if (e.getMessage() != null) {
            result.append(" with message:").append(System.lineSeparator()).append(e.getMessage());
        } else {
            result.append(" without a message");
        }
        return result.toString();
    }

    private String getRuleName(EnforcerRuleDesc ruleDesc) {
        Class<?> ruleClass = ruleDesc.getRule().getClass();
        String ruleName = ruleClass.getName();
        if (!ruleClass.getSimpleName().equalsIgnoreCase(ruleDesc.getName())) {
            ruleName = ruleName + "(" + ruleDesc.getName() + ")";
        }
        return ruleName;
    }

    public void setFailIfNoRules(boolean thefailIfNoRules) {
        this.failIfNoRules = thefailIfNoRules;
    }
}

