/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer.internal;

import java.util.Objects;
import java.util.function.Supplier;
import org.apache.maven.enforcer.rule.api.EnforcerLogger;
import org.apache.maven.plugin.logging.Log;

public abstract class AbstractEnforcerLogger
implements EnforcerLogger {
    protected final Log log;

    protected AbstractEnforcerLogger(Log log) {
        this.log = Objects.requireNonNull(log, "log must be not null");
    }

    public void debug(CharSequence message) {
        this.log.debug(message);
    }

    public void debug(Supplier<CharSequence> messageSupplier) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(messageSupplier.get());
        }
    }

    public void info(CharSequence message) {
        this.log.info(message);
    }

    public void info(Supplier<CharSequence> messageSupplier) {
        if (this.log.isInfoEnabled()) {
            this.log.info(messageSupplier.get());
        }
    }

    public void warn(CharSequence message) {
        this.log.warn(message);
    }

    public void warn(Supplier<CharSequence> messageSupplier) {
        if (this.log.isWarnEnabled()) {
            this.log.warn(messageSupplier.get());
        }
    }

    public void error(CharSequence message) {
        this.log.error(message);
    }

    public void error(Supplier<CharSequence> messageSupplier) {
        if (this.log.isErrorEnabled()) {
            this.log.error(messageSupplier.get());
        }
    }
}

