/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.jazz.command.add;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.add.AbstractAddCommand;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.jazz.command.JazzScmCommand;
import org.apache.maven.scm.provider.jazz.command.add.JazzAddConsumer;
import org.apache.maven.scm.provider.jazz.command.consumer.ErrorConsumer;
import org.apache.maven.scm.provider.jazz.command.status.JazzStatusCommand;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JazzAddCommand
extends AbstractAddCommand {
    protected ScmResult executeAddCommand(ScmProviderRepository repo, ScmFileSet fileSet, String message, boolean binary) throws ScmException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Executing add command...");
        }
        return this.executeAddCommand(repo, fileSet);
    }

    public AddScmResult executeAddCommand(ScmProviderRepository repo, ScmFileSet fileSet) throws ScmException {
        File baseDir = fileSet.getBasedir();
        File parentFolder = baseDir.getParentFile() != null ? baseDir.getParentFile() : baseDir;
        ArrayList<ScmFile> changedScmFiles = new ArrayList<ScmFile>();
        ArrayList<File> changedFiles = new ArrayList<File>();
        ArrayList<ScmFile> commitedFiles = new ArrayList<ScmFile>();
        JazzStatusCommand statusCmd = new JazzStatusCommand();
        statusCmd.setLogger(this.getLogger());
        StatusScmResult statusCmdResult = statusCmd.executeStatusCommand(repo, fileSet);
        List statusScmFiles = statusCmdResult.getChangedFiles();
        for (ScmFile file : statusScmFiles) {
            this.getLogger().debug("Iterating over statusScmFiles: " + file);
            if (file.getStatus() != ScmFileStatus.ADDED && file.getStatus() != ScmFileStatus.DELETED && file.getStatus() != ScmFileStatus.MODIFIED) continue;
            changedScmFiles.add(new ScmFile(file.getPath(), ScmFileStatus.CHECKED_IN));
            changedFiles.add(new File(parentFolder, file.getPath()));
        }
        List files = fileSet.getFileList();
        if (files.size() == 0) {
            commitedFiles = changedScmFiles;
        } else {
            for (int i = 0; i < files.size(); ++i) {
                if (!this.fileExistsInFileList((File)files.get(i), changedFiles)) continue;
                commitedFiles.add(new ScmFile(((File)files.get(i)).getPath(), ScmFileStatus.CHECKED_IN));
            }
        }
        JazzAddConsumer addConsumer = new JazzAddConsumer(repo, this.getLogger());
        ErrorConsumer errConsumer = new ErrorConsumer(this.getLogger());
        JazzScmCommand command = this.createAddCommand(repo, fileSet);
        int status = command.execute((StreamConsumer)addConsumer, errConsumer);
        if (status != 0 || errConsumer.hasBeenFed()) {
            return new AddScmResult(command.getCommandString(), "Error code for Jazz SCM add (checkin) command - " + status, errConsumer.getOutput(), false);
        }
        return new AddScmResult(command.getCommandString(), addConsumer.getFiles());
    }

    public JazzScmCommand createAddCommand(ScmProviderRepository repo, ScmFileSet fileSet) {
        JazzScmCommand command = new JazzScmCommand("checkin", null, repo, false, fileSet, this.getLogger());
        List files = fileSet.getFileList();
        if (files != null && !files.isEmpty()) {
            for (File file : files) {
                command.addArgument(file.getPath());
            }
        } else {
            command.addArgument(".");
        }
        return command;
    }

    private boolean fileExistsInFileList(File file, List<File> fileList) {
        boolean exists = false;
        for (File changedFile : fileList) {
            if (changedFile.compareTo(file) != 0) continue;
            exists = true;
            break;
        }
        return exists;
    }
}

