/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.constraints;

import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.Declaration;
import org.drools.model.Binding;

public class BindingEvaluator {
    private final Declaration[] declarations;
    protected final Binding binding;

    public BindingEvaluator(Declaration[] declarations, Binding binding) {
        this.declarations = declarations;
        this.binding = binding;
    }

    public Object evaluate(InternalFactHandle handle, Tuple tuple, ReteEvaluator reteEvaluator, Declaration[] declarations, Declaration[] innerDeclarations) {
        return this.evaluate(this.getArguments(handle, tuple, reteEvaluator, declarations, innerDeclarations));
    }

    public Object evaluate(Object ... args) {
        return this.binding.eval(args);
    }

    public Declaration[] getDeclarations() {
        return this.declarations;
    }

    private Object[] getArguments(InternalFactHandle handle, Tuple tuple, ReteEvaluator reteEvaluator, Declaration[] declarations, Declaration[] innerDeclarations) {
        int i;
        Object[] params = new Object[declarations.length + innerDeclarations.length];
        for (i = 0; i < innerDeclarations.length; ++i) {
            params[i] = BindingEvaluator.getArgument(handle, reteEvaluator, innerDeclarations[i], tuple);
        }
        for (i = 0; i < declarations.length; ++i) {
            params[i + innerDeclarations.length] = BindingEvaluator.getArgument(handle, reteEvaluator, declarations[i], tuple);
        }
        return params;
    }

    public static Object getArgument(InternalFactHandle handle, ReteEvaluator reteEvaluator, Declaration declaration, Tuple tuple) {
        int tupleIndex = declaration.getTupleIndex();
        return declaration.getValue(reteEvaluator, tuple != null && tupleIndex < tuple.size() ? tuple.get(tupleIndex) : handle);
    }
}

