/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.constraints;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.phreak.ReactiveObject;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.accessor.DataProvider;
import org.drools.model.functions.FunctionN;

public class LambdaDataProvider
implements DataProvider {
    private final FunctionN providerFunction;
    private Declaration[] declarations;
    private final boolean reactive;

    public LambdaDataProvider(FunctionN providerFunction, boolean reactive, Declaration ... declarations) {
        this.declarations = declarations;
        this.providerFunction = providerFunction;
        this.reactive = reactive;
    }

    public Declaration[] getRequiredDeclarations() {
        return this.declarations;
    }

    public Object createContext() {
        return null;
    }

    public Iterator getResults(Tuple tuple, ReteEvaluator reteEvaluator, PropagationContext ctx, Object providerContext) {
        Object result = this.getResult(tuple, reteEvaluator);
        if (this.isReactive()) {
            if (result instanceof ReactiveObject) {
                ((ReactiveObject)result).addLeftTuple(tuple);
            }
            if (result instanceof Iterable) {
                for (Object value : (Iterable)result) {
                    if (!(value instanceof ReactiveObject)) continue;
                    ((ReactiveObject)value).addLeftTuple(tuple);
                }
            }
        }
        if (result instanceof Object[]) {
            return Arrays.asList((Object[])result).iterator();
        }
        if (result instanceof Iterator) {
            return (Iterator)result;
        }
        if (result instanceof Iterable) {
            return ((Iterable)result).iterator();
        }
        return Collections.singletonList(result).iterator();
    }

    private Object getResult(Tuple tuple, ReteEvaluator reteEvaluator) {
        Object result;
        if (this.declarations.length == 0) {
            result = this.providerFunction.apply(new Object[0]);
        } else if (this.declarations.length == 1) {
            result = this.getValueForDeclaration(tuple, reteEvaluator, this.declarations[0]);
            if (this.providerFunction != null) {
                result = this.providerFunction.apply(new Object[]{result});
            }
        } else {
            Object[] args = new Object[this.declarations.length];
            for (int i = 0; i < this.declarations.length; ++i) {
                args[i] = this.getValueForDeclaration(tuple, reteEvaluator, this.declarations[i]);
            }
            result = this.providerFunction.apply(args);
        }
        return result;
    }

    private Object getValueForDeclaration(Tuple tuple, ReteEvaluator reteEvaluator, Declaration declaration) {
        return declaration.getExtractor().isGlobal() ? declaration.getExtractor().getValue(reteEvaluator, (Object)declaration.getIdentifier()) : declaration.getValue(reteEvaluator, tuple);
    }

    public DataProvider clone() {
        Declaration[] clonedDecls = new Declaration[this.declarations.length];
        for (int i = 0; i < this.declarations.length; ++i) {
            clonedDecls[i] = this.declarations[i].clone();
        }
        return new LambdaDataProvider(this.providerFunction, this.reactive, clonedDecls);
    }

    public void replaceDeclaration(Declaration declaration, Declaration resolved) {
        for (int i = 0; i < this.declarations.length; ++i) {
            if (!this.declarations[i].getIdentifier().equals(declaration.getIdentifier())) continue;
            this.declarations[i] = resolved;
        }
    }

    public boolean isReactive() {
        return this.reactive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LambdaDataProvider that = (LambdaDataProvider)o;
        return this.reactive == that.reactive && Objects.equals(this.providerFunction, that.providerFunction) && Arrays.equals(this.declarations, that.declarations);
    }

    public int hashCode() {
        return Objects.hash(this.providerFunction, Arrays.hashCode(this.declarations), this.reactive);
    }
}

