/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.constraints;

import java.io.Serializable;
import org.drools.core.base.DroolsQuery;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.ContextEntry;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.IndexableConstraint;
import org.drools.core.rule.MutableTypeConstraint;
import org.drools.core.rule.accessor.FieldValue;
import org.drools.core.rule.accessor.ReadAccessor;
import org.drools.core.rule.accessor.TupleValueExtractor;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.index.IndexUtil;
import org.drools.model.Index;
import org.drools.model.functions.Function1;
import org.drools.modelcompiler.constraints.ConstraintEvaluator;
import org.drools.modelcompiler.constraints.LambdaConstraint;
import org.drools.modelcompiler.constraints.LambdaReadAccessor;
import org.kie.api.KieBaseConfiguration;

public class UnificationConstraint
extends MutableTypeConstraint
implements IndexableConstraint {
    private Declaration indexingDeclaration;
    private final ReadAccessor readAccessor;
    private final ConstraintEvaluator evaluator;
    private boolean unification = true;

    public UnificationConstraint(Declaration indexingDeclaration) {
        this(indexingDeclaration, null);
    }

    public UnificationConstraint(Declaration indexingDeclaration, ConstraintEvaluator evaluator) {
        this.indexingDeclaration = indexingDeclaration;
        this.evaluator = evaluator;
        if (evaluator != null) {
            Index index = evaluator.getIndex();
            this.readAccessor = new LambdaReadAccessor(index.getIndexId(), index.getIndexedClass(), index.getLeftOperandExtractor());
        } else {
            this.readAccessor = new LambdaReadAccessor(indexingDeclaration.getDeclarationClass(), (Function1 & Serializable)x -> x);
        }
    }

    public boolean isUnification() {
        return this.unification;
    }

    public void unsetUnification() {
        this.unification = false;
    }

    public boolean isIndexable(short nodeType, KieBaseConfiguration config) {
        return true;
    }

    public IndexUtil.ConstraintType getConstraintType() {
        return IndexUtil.ConstraintType.EQUAL;
    }

    public FieldValue getField() {
        throw new UnsupportedOperationException();
    }

    public AbstractHashTable.FieldIndex getFieldIndex() {
        return new AbstractHashTable.FieldIndex(this.readAccessor, (TupleValueExtractor)this.indexingDeclaration);
    }

    public ReadAccessor getFieldExtractor() {
        return this.readAccessor;
    }

    public Declaration getIndexExtractor() {
        return this.indexingDeclaration;
    }

    public Declaration[] getRequiredDeclarations() {
        return new Declaration[]{this.indexingDeclaration};
    }

    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        if (this.indexingDeclaration == oldDecl) {
            this.indexingDeclaration = newDecl;
        }
        if (this.evaluator != null) {
            this.evaluator.replaceDeclaration(oldDecl, newDecl);
        }
    }

    public MutableTypeConstraint clone() {
        return new UnificationConstraint(this.indexingDeclaration, this.evaluator);
    }

    public boolean isTemporal() {
        return false;
    }

    public boolean isAllowed(InternalFactHandle handle, ReteEvaluator reteEvaluator) {
        throw new UnsupportedOperationException();
    }

    public boolean isAllowedCachedLeft(ContextEntry context, InternalFactHandle handle) {
        return this.evaluateUnification(handle, ((LambdaConstraint.LambdaContextEntry)context).getTuple(), ((LambdaConstraint.LambdaContextEntry)context).getReteEvaluator());
    }

    public boolean isAllowedCachedRight(Tuple tuple, ContextEntry context) {
        return this.evaluateUnification(((LambdaConstraint.LambdaContextEntry)context).getHandle(), tuple, ((LambdaConstraint.LambdaContextEntry)context).getReteEvaluator());
    }

    private boolean evaluateUnification(InternalFactHandle handle, Tuple tuple, ReteEvaluator reteEvaluator) {
        if (!this.unification) {
            return this.evaluator.evaluate(handle, tuple, reteEvaluator);
        }
        DroolsQuery query = (DroolsQuery)tuple.getObject(0);
        if (query.getVariables()[this.indexingDeclaration.getExtractor().getIndex()] != null) {
            return true;
        }
        if (this.evaluator != null) {
            return this.evaluator.evaluate(handle, tuple, reteEvaluator);
        }
        Object argument = this.indexingDeclaration.getValue(null, (Object)query);
        return handle.getObject().equals(argument);
    }

    public ContextEntry createContextEntry() {
        return new LambdaConstraint.LambdaContextEntry();
    }
}

