/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import junit.framework.TestCase;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerFactory;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.impl.GeoServerImpl;
import org.geoserver.config.impl.ServiceInfoImpl;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geotools.referencing.CRS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XStreamPersisterTest
extends TestCase {
    GeoServerFactory factory;
    CatalogFactory cfactory;
    XStreamPersister persister;

    protected void setUp() throws Exception {
        super.setUp();
        this.factory = new GeoServerImpl().getFactory();
        this.persister = new XStreamPersisterFactory().createXMLPersister();
    }

    public void testGlobal() throws Exception {
        GeoServerInfo g1 = this.factory.createGlobal();
        g1.setAdminPassword("foo");
        g1.setAdminUsername("bar");
        g1.setCharset("ISO-8859-1");
        ContactInfo contact = this.factory.createContact();
        g1.setContact(contact);
        contact.setAddress("123");
        contact.setAddressCity("Victoria");
        contact.setAddressCountry("Canada");
        contact.setAddressPostalCode("V1T3T8");
        contact.setAddressState("BC");
        contact.setAddressType("house");
        contact.setContactEmail("bob@acme.org");
        contact.setContactFacsimile("+1 250 123 4567");
        contact.setContactOrganization("Acme");
        contact.setContactPerson("Bob");
        contact.setContactPosition("hacker");
        contact.setContactVoice("+1 250 765 4321");
        g1.setNumDecimals(2);
        g1.setOnlineResource("http://acme.org");
        g1.setProxyBaseUrl("http://proxy.acme.org");
        g1.setSchemaBaseUrl("http://schemas.acme.org");
        g1.setTitle("Acme's GeoServer");
        g1.setUpdateSequence(123L);
        g1.setVerbose(true);
        g1.setVerboseExceptions(true);
        g1.getMetadata().put("one", (Serializable)new Integer(1));
        g1.getMetadata().put("two", (Serializable)new Double(2.2));
        ByteArrayOutputStream out = this.out();
        this.persister.save((Object)g1, (OutputStream)out);
        GeoServerInfo g2 = (GeoServerInfo)this.persister.load((InputStream)this.in(out), GeoServerInfo.class);
        XStreamPersisterTest.assertEquals((Object)g1, (Object)g2);
        Document dom = this.dom(this.in(out));
        XStreamPersisterTest.assertEquals((String)"global", (String)dom.getDocumentElement().getNodeName());
    }

    public void testLogging() throws Exception {
        LoggingInfo logging = this.factory.createLogging();
        logging.setLevel("CRAZY_LOGGING");
        logging.setLocation("some/place/geoserver.log");
        logging.setStdOutLogging(true);
        ByteArrayOutputStream out = this.out();
        this.persister.save((Object)logging, (OutputStream)out);
        LoggingInfo logging2 = (LoggingInfo)this.persister.load((InputStream)this.in(out), LoggingInfo.class);
        XStreamPersisterTest.assertEquals((Object)logging, (Object)logging2);
        Document dom = this.dom(this.in(out));
        XStreamPersisterTest.assertEquals((String)"logging", (String)dom.getDocumentElement().getNodeName());
    }

    public void testGobalContactDefault() throws Exception {
        GeoServerInfo g1 = this.factory.createGlobal();
        ContactInfo contact = this.factory.createContact();
        g1.setContact(contact);
        ByteArrayOutputStream out = this.out();
        this.persister.save((Object)g1, (OutputStream)out);
        ByteArrayInputStream in = this.in(out);
        Document dom = this.dom(in);
        Element e = (Element)dom.getElementsByTagName("contact").item(0);
        e.removeAttribute("class");
        in = this.in(dom);
        GeoServerInfo g2 = (GeoServerInfo)this.persister.load((InputStream)in, GeoServerInfo.class);
        XStreamPersisterTest.assertEquals((Object)g1, (Object)g2);
    }

    public void testService() throws Exception {
        MyServiceInfo s1 = new MyServiceInfo();
        s1.setAbstract("my service abstract");
        s1.setAccessConstraints("no constraints");
        s1.setCiteCompliant(true);
        s1.setEnabled(true);
        s1.setFees("no fees");
        s1.setFoo("bar");
        s1.setId("id");
        s1.setMaintainer("Bob");
        s1.setMetadataLink(this.factory.createMetadataLink());
        s1.setName("MS");
        s1.setOnlineResource("http://acme.org?service=myservice");
        s1.setOutputStrategy("FAST");
        s1.setSchemaBaseURL("http://schemas.acme.org/");
        s1.setTitle("My Service");
        s1.setVerbose(true);
        ByteArrayOutputStream out = this.out();
        this.persister.save((Object)s1, (OutputStream)out);
        MyServiceInfo s2 = (MyServiceInfo)((Object)this.persister.load((InputStream)this.in(out), MyServiceInfo.class));
        XStreamPersisterTest.assertEquals((String)s1.getAbstract(), (String)s2.getAbstract());
        XStreamPersisterTest.assertEquals((String)s1.getAccessConstraints(), (String)s2.getAccessConstraints());
        XStreamPersisterTest.assertEquals((boolean)s1.isCiteCompliant(), (boolean)s2.isCiteCompliant());
        XStreamPersisterTest.assertEquals((boolean)s1.isEnabled(), (boolean)s2.isEnabled());
        XStreamPersisterTest.assertEquals((String)s1.getFees(), (String)s2.getFees());
        XStreamPersisterTest.assertEquals((String)s1.getFoo(), (String)s2.getFoo());
        XStreamPersisterTest.assertEquals((String)s1.getId(), (String)s2.getId());
        XStreamPersisterTest.assertEquals((String)s1.getMaintainer(), (String)s2.getMaintainer());
        XStreamPersisterTest.assertEquals((Object)s1.getMetadataLink(), (Object)s2.getMetadataLink());
        XStreamPersisterTest.assertEquals((String)s1.getName(), (String)s2.getName());
        XStreamPersisterTest.assertEquals((String)s1.getOnlineResource(), (String)s2.getOnlineResource());
        XStreamPersisterTest.assertEquals((String)s1.getOutputStrategy(), (String)s2.getOutputStrategy());
        XStreamPersisterTest.assertEquals((String)s1.getSchemaBaseURL(), (String)s2.getSchemaBaseURL());
        XStreamPersisterTest.assertEquals((String)s1.getTitle(), (String)s2.getTitle());
        XStreamPersisterTest.assertEquals((boolean)s1.isVerbose(), (boolean)s2.isVerbose());
    }

    public void testServiceOmitGlobal() throws Exception {
        MyServiceInfo s1 = new MyServiceInfo();
        s1.setGeoServer((GeoServer)new GeoServerImpl());
        ByteArrayOutputStream out = this.out();
        this.persister.save((Object)s1, (OutputStream)out);
        MyServiceInfo s2 = (MyServiceInfo)((Object)this.persister.load((InputStream)this.in(out), MyServiceInfo.class));
        XStreamPersisterTest.assertNull((Object)s2.getGeoServer());
    }

    public void testServiceCustomAlias() throws Exception {
        XStreamPersister p = this.persister = new XStreamPersisterFactory().createXMLPersister();
        p.getXStream().alias("ms", MyServiceInfo.class);
        MyServiceInfo s1 = new MyServiceInfo();
        ByteArrayOutputStream out = this.out();
        p.save((Object)s1, (OutputStream)out);
        Document dom = this.dom(this.in(out));
        XStreamPersisterTest.assertEquals((String)"ms", (String)dom.getDocumentElement().getNodeName());
    }

    public void testDataStore() throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        WorkspaceInfo ws = cFactory.createWorkspace();
        ws.setName("foo");
        DataStoreInfo ds1 = cFactory.createDataStore();
        ds1.setName("bar");
        ds1.setWorkspace(ws);
        ByteArrayOutputStream out = this.out();
        this.persister.save((Object)ds1, (OutputStream)out);
        DataStoreInfo ds2 = (DataStoreInfo)this.persister.load((InputStream)this.in(out), DataStoreInfo.class);
        XStreamPersisterTest.assertEquals((String)"bar", (String)ds2.getName());
        Document dom = this.dom(this.in(out));
        XStreamPersisterTest.assertEquals((String)"dataStore", (String)dom.getDocumentElement().getNodeName());
    }

    public void testCoverageStore() throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        WorkspaceInfo ws = cFactory.createWorkspace();
        ws.setName("foo");
        CoverageStoreInfo cs1 = cFactory.createCoverageStore();
        cs1.setName("bar");
        cs1.setWorkspace(ws);
        ByteArrayOutputStream out = this.out();
        this.persister.save((Object)cs1, (OutputStream)out);
        CoverageStoreInfo ds2 = (CoverageStoreInfo)this.persister.load((InputStream)this.in(out), CoverageStoreInfo.class);
        XStreamPersisterTest.assertEquals((String)"bar", (String)ds2.getName());
        Document dom = this.dom(this.in(out));
        XStreamPersisterTest.assertEquals((String)"coverageStore", (String)dom.getDocumentElement().getNodeName());
    }

    public void testStyle() throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        StyleInfo s1 = cFactory.createStyle();
        s1.setName("foo");
        s1.setFilename("foo.sld");
        ByteArrayOutputStream out = this.out();
        this.persister.save((Object)s1, (OutputStream)out);
        ByteArrayInputStream in = this.in(out);
        StyleInfo s2 = (StyleInfo)this.persister.load((InputStream)in, StyleInfo.class);
        XStreamPersisterTest.assertEquals((Object)s1, (Object)s2);
        Document dom = this.dom(this.in(out));
        XStreamPersisterTest.assertEquals((String)"style", (String)dom.getDocumentElement().getNodeName());
    }

    public void testCatalog() throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        WorkspaceInfo ws = cFactory.createWorkspace();
        ws.setName("foo");
        catalog.add(ws);
        NamespaceInfo ns = cFactory.createNamespace();
        ns.setPrefix("acme");
        ns.setURI("http://acme.org");
        catalog.add(ns);
        DataStoreInfo ds = cFactory.createDataStore();
        ds.setWorkspace(ws);
        ds.setName("foo");
        catalog.add((StoreInfo)ds);
        CoverageStoreInfo cs = cFactory.createCoverageStore();
        cs.setWorkspace(ws);
        cs.setName("bar");
        catalog.add((StoreInfo)cs);
        StyleInfo s = cFactory.createStyle();
        s.setName("style");
        s.setFilename("style.sld");
        catalog.add(s);
        ByteArrayOutputStream out = this.out();
        this.persister.save((Object)catalog, (OutputStream)out);
        catalog = (Catalog)this.persister.load((InputStream)this.in(out), Catalog.class);
        XStreamPersisterTest.assertNotNull((Object)catalog);
        XStreamPersisterTest.assertEquals((int)1, (int)catalog.getWorkspaces().size());
        XStreamPersisterTest.assertNotNull((Object)catalog.getDefaultWorkspace());
        ws = catalog.getDefaultWorkspace();
        XStreamPersisterTest.assertEquals((String)"foo", (String)ws.getName());
        XStreamPersisterTest.assertEquals((int)1, (int)catalog.getNamespaces().size());
        XStreamPersisterTest.assertNotNull((Object)catalog.getDefaultNamespace());
        ns = catalog.getDefaultNamespace();
        XStreamPersisterTest.assertEquals((String)"acme", (String)ns.getPrefix());
        XStreamPersisterTest.assertEquals((String)"http://acme.org", (String)ns.getURI());
        XStreamPersisterTest.assertEquals((int)1, (int)catalog.getDataStores().size());
        ds = (DataStoreInfo)catalog.getDataStores().get(0);
        XStreamPersisterTest.assertEquals((String)"foo", (String)ds.getName());
        XStreamPersisterTest.assertNotNull((Object)ds.getWorkspace());
        XStreamPersisterTest.assertEquals((Object)ws, (Object)ds.getWorkspace());
        XStreamPersisterTest.assertEquals((int)1, (int)catalog.getCoverageStores().size());
        cs = (CoverageStoreInfo)catalog.getCoverageStores().get(0);
        XStreamPersisterTest.assertEquals((String)"bar", (String)cs.getName());
        XStreamPersisterTest.assertEquals((Object)ws, (Object)cs.getWorkspace());
        XStreamPersisterTest.assertEquals((int)1, (int)catalog.getStyles().size());
        s = (StyleInfo)catalog.getStyles().get(0);
        XStreamPersisterTest.assertEquals((String)"style", (String)s.getName());
        XStreamPersisterTest.assertEquals((String)"style.sld", (String)s.getFilename());
    }

    public void testFeatureType() throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        WorkspaceInfo ws = cFactory.createWorkspace();
        ws.setName("foo");
        catalog.add(ws);
        NamespaceInfo ns = cFactory.createNamespace();
        ns.setPrefix("acme");
        ns.setURI("http://acme.org");
        catalog.add(ns);
        DataStoreInfo ds = cFactory.createDataStore();
        ds.setWorkspace(ws);
        ds.setName("foo");
        catalog.add((StoreInfo)ds);
        FeatureTypeInfo ft = cFactory.createFeatureType();
        ft.setStore((StoreInfo)ds);
        ft.setNamespace(ns);
        ft.setName("ft");
        ft.setAbstract("abstract");
        ft.setSRS("EPSG:4326");
        ft.setNativeCRS(CRS.decode((String)"EPSG:4326"));
        ByteArrayOutputStream out = this.out();
        this.persister.save((Object)ft, (OutputStream)out);
        this.persister.setCatalog((Catalog)catalog);
        ft = (FeatureTypeInfo)this.persister.load((InputStream)this.in(out), FeatureTypeInfo.class);
        XStreamPersisterTest.assertNotNull((Object)ft);
        XStreamPersisterTest.assertEquals((String)"ft", (String)ft.getName());
        XStreamPersisterTest.assertEquals((Object)ds, (Object)ft.getStore());
        XStreamPersisterTest.assertEquals((Object)ns, (Object)ft.getNamespace());
        XStreamPersisterTest.assertEquals((String)"EPSG:4326", (String)ft.getSRS());
        XStreamPersisterTest.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)CRS.decode((String)"EPSG:4326"), (Object)ft.getNativeCRS()));
    }

    public void testLayer() throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        WorkspaceInfo ws = cFactory.createWorkspace();
        ws.setName("foo");
        catalog.add(ws);
        NamespaceInfo ns = cFactory.createNamespace();
        ns.setPrefix("acme");
        ns.setURI("http://acme.org");
        catalog.add(ns);
        DataStoreInfo ds = cFactory.createDataStore();
        ds.setWorkspace(ws);
        ds.setName("foo");
        catalog.add((StoreInfo)ds);
        FeatureTypeInfo ft = cFactory.createFeatureType();
        ft.setStore((StoreInfo)ds);
        ft.setNamespace(ns);
        ft.setName("ft");
        ft.setAbstract("abstract");
        ft.setSRS("EPSG:4326");
        ft.setNativeCRS(CRS.decode((String)"EPSG:4326"));
        catalog.add((ResourceInfo)ft);
        StyleInfo s = cFactory.createStyle();
        s.setName("style");
        s.setFilename("style.sld");
        catalog.add(s);
        LayerInfo l = cFactory.createLayer();
        l.setResource((ResourceInfo)ft);
        l.setDefaultStyle(s);
        catalog.add(l);
        ByteArrayOutputStream out = this.out();
        this.persister.save((Object)l, (OutputStream)out);
        this.persister.setCatalog((Catalog)catalog);
        l = (LayerInfo)this.persister.load((InputStream)this.in(out), LayerInfo.class);
        XStreamPersisterTest.assertEquals((String)l.getResource().getName(), (String)l.getName());
        XStreamPersisterTest.assertEquals((Object)ft, (Object)l.getResource());
        XStreamPersisterTest.assertEquals((Object)s, (Object)l.getDefaultStyle());
    }

    ByteArrayOutputStream out() {
        return new ByteArrayOutputStream();
    }

    ByteArrayInputStream in(ByteArrayOutputStream in) {
        return new ByteArrayInputStream(in.toByteArray());
    }

    ByteArrayInputStream in(Document dom) throws Exception {
        Transformer tx = TransformerFactory.newInstance().newTransformer();
        tx.setOutputProperty("indent", "yes");
        ByteArrayOutputStream out = this.out();
        tx.transform(new DOMSource(dom), new StreamResult(out));
        return this.in(out);
    }

    Document dom(InputStream in) throws Exception {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
    }

    void print(InputStream in) throws Exception {
        Transformer tx = TransformerFactory.newInstance().newTransformer();
        tx.setOutputProperty("indent", "yes");
        tx.transform(new StreamSource(in), new StreamResult(System.out));
    }

    static class MyServiceInfo
    extends ServiceInfoImpl {
        String foo;

        MyServiceInfo() {
        }

        String getFoo() {
            return this.foo;
        }

        void setFoo(String foo) {
            this.foo = foo;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MyServiceInfo)) {
                return false;
            }
            MyServiceInfo other = (MyServiceInfo)((Object)obj);
            if (this.foo == null ? other.foo != null : !this.foo.equals(other.foo)) {
                return false;
            }
            return super.equals((Object)other);
        }
    }
}

