/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.File;
import java.io.InputStream;
import org.acegisecurity.AcegiSecurityException;
import org.geoserver.data.test.MockData;
import org.geoserver.data.util.IOUtils;
import org.geoserver.test.GeoServerTestSupport;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public class SecureCatalogIntegrationTest
extends GeoServerTestSupport {
    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        File security = new File(dataDirectory.getDataDirectoryRoot(), "security");
        security.mkdir();
        File layers = new File(security, "layers.properties");
        IOUtils.copy((InputStream)SecureCatalogIntegrationTest.class.getResourceAsStream("functional.properties"), (File)layers);
    }

    public void testFullAccess() throws Exception {
        FeatureSource<SimpleFeatureType, SimpleFeature> source = this.getFeatureSource(MockData.LINES);
        FeatureCollection fc = source.getFeatures();
        FeatureStore store = (FeatureStore)source;
        store.removeFeatures((Filter)Filter.INCLUDE);
    }

    public void testCannotRead() throws Exception {
        try {
            this.getFeatureSource(MockData.BUILDINGS);
            SecureCatalogIntegrationTest.fail((String)"This should have failed with a security exception!");
        }
        catch (AcegiSecurityException acegiSecurityException) {
            // empty catch block
        }
    }

    public void testCannotWrite() throws Exception {
        FeatureStore fs = (FeatureStore)this.getFeatureSource(MockData.DELETES);
        try {
            fs.removeFeatures((Filter)Filter.INCLUDE);
            SecureCatalogIntegrationTest.fail((String)"This should have failed with a security exception!");
        }
        catch (AcegiSecurityException acegiSecurityException) {
            // empty catch block
        }
    }
}

