/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import org.acegisecurity.AcegiSecurityException;
import org.easymock.EasyMock;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.SecureObjectsTest;
import org.geoserver.security.decorators.ReadOnlyDataAccess;
import org.geoserver.security.decorators.ReadOnlyFeatureSource;
import org.geotools.data.DataAccess;
import org.geotools.data.FeatureSource;
import org.geotools.feature.NameImpl;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;

public class ReadOnlyDataAccessTest
extends SecureObjectsTest {
    private DataAccess da;
    private NameImpl name;

    protected void setUp() throws Exception {
        super.setUp();
        FeatureSource fs = (FeatureSource)EasyMock.createNiceMock(FeatureSource.class);
        EasyMock.replay((Object[])new Object[]{fs});
        FeatureType schema = (FeatureType)EasyMock.createNiceMock(FeatureType.class);
        EasyMock.replay((Object[])new Object[]{schema});
        this.da = (DataAccess)EasyMock.createNiceMock(DataAccess.class);
        this.name = new NameImpl("blah");
        EasyMock.expect((Object)this.da.getFeatureSource((Name)this.name)).andReturn((Object)fs);
        EasyMock.replay((Object[])new Object[]{this.da});
    }

    public void testDontChallenge() throws Exception {
        ReadOnlyDataAccess ro = new ReadOnlyDataAccess(this.da, SecureCatalogImpl.WrapperPolicy.HIDE);
        ReadOnlyFeatureSource fs = (ReadOnlyFeatureSource)ro.getFeatureSource((Name)this.name);
        ReadOnlyDataAccessTest.assertEquals((Object)SecureCatalogImpl.WrapperPolicy.HIDE, (Object)fs.policy);
        try {
            ro.createSchema(null);
            ReadOnlyDataAccessTest.fail((String)"Should have failed with an unsupported operation exception");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            ro.updateSchema(null, null);
            ReadOnlyDataAccessTest.fail((String)"Should have failed with an unsupported operation exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testChallenge() throws Exception {
        ReadOnlyDataAccess ro = new ReadOnlyDataAccess(this.da, SecureCatalogImpl.WrapperPolicy.RO_CHALLENGE);
        ReadOnlyFeatureSource fs = (ReadOnlyFeatureSource)ro.getFeatureSource((Name)this.name);
        ReadOnlyDataAccessTest.assertEquals((Object)SecureCatalogImpl.WrapperPolicy.RO_CHALLENGE, (Object)fs.policy);
        try {
            ro.createSchema(null);
            ReadOnlyDataAccessTest.fail((String)"Should have failed with a security exception");
        }
        catch (AcegiSecurityException e) {
            // empty catch block
        }
        try {
            ro.updateSchema(null, null);
            ReadOnlyDataAccessTest.fail((String)"Should have failed with a security exception");
        }
        catch (AcegiSecurityException acegiSecurityException) {
            // empty catch block
        }
    }
}

