/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import org.acegisecurity.AcegiSecurityException;
import org.easymock.EasyMock;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.SecureObjectsTest;
import org.geoserver.security.decorators.ReadOnlyDataStore;
import org.geoserver.security.decorators.ReadOnlyFeatureSource;
import org.geoserver.security.decorators.ReadOnlyFeatureStore;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

public class ReadOnlyDataStoreTest
extends SecureObjectsTest {
    private DataStore ds;

    protected void setUp() throws Exception {
        super.setUp();
        FeatureStore fs = (FeatureStore)EasyMock.createNiceMock(FeatureStore.class);
        EasyMock.replay((Object[])new Object[]{fs});
        this.ds = (DataStore)EasyMock.createNiceMock(DataStore.class);
        EasyMock.expect((Object)this.ds.getFeatureSource("blah")).andReturn((Object)fs);
        EasyMock.replay((Object[])new Object[]{this.ds});
    }

    public void testDontChallenge() throws Exception {
        ReadOnlyDataStore ro = new ReadOnlyDataStore(this.ds, SecureCatalogImpl.WrapperPolicy.HIDE);
        ReadOnlyFeatureSource fs = (ReadOnlyFeatureSource)ro.getFeatureSource("blah");
        ReadOnlyDataStoreTest.assertEquals((Object)SecureCatalogImpl.WrapperPolicy.HIDE, (Object)fs.policy);
        try {
            ro.createSchema(null);
            ReadOnlyDataStoreTest.fail((String)"Should have failed with an unsupported operation exception");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            ro.updateSchema((String)null, null);
            ReadOnlyDataStoreTest.fail((String)"Should have failed with an unsupported operation exception");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            ro.updateSchema((Name)null, null);
            ReadOnlyDataStoreTest.fail((String)"Should have failed with an unsupported operation exception");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            ro.getFeatureWriter("states", Transaction.AUTO_COMMIT);
            ReadOnlyDataStoreTest.fail((String)"Should have failed with an unsupported operation exception");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            ro.getFeatureWriter("states", (Filter)Filter.INCLUDE, Transaction.AUTO_COMMIT);
            ReadOnlyDataStoreTest.fail((String)"Should have failed with an unsupported operation exception");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            ro.getFeatureWriterAppend("states", Transaction.AUTO_COMMIT);
            ReadOnlyDataStoreTest.fail((String)"Should have failed with an unsupported operation exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testChallenge() throws Exception {
        ReadOnlyDataStore ro = new ReadOnlyDataStore(this.ds, SecureCatalogImpl.WrapperPolicy.RO_CHALLENGE);
        ReadOnlyFeatureStore fs = (ReadOnlyFeatureStore)ro.getFeatureSource("blah");
        ReadOnlyDataStoreTest.assertEquals((Object)SecureCatalogImpl.WrapperPolicy.RO_CHALLENGE, (Object)fs.policy);
        try {
            ro.createSchema(null);
            ReadOnlyDataStoreTest.fail((String)"Should have failed with a security exception");
        }
        catch (AcegiSecurityException e) {
            // empty catch block
        }
        try {
            ro.updateSchema((String)null, null);
            ReadOnlyDataStoreTest.fail((String)"Should have failed with a security exception");
        }
        catch (AcegiSecurityException e) {
            // empty catch block
        }
        try {
            ro.updateSchema((Name)null, null);
            ReadOnlyDataStoreTest.fail((String)"Should have failed with a security exception");
        }
        catch (AcegiSecurityException e) {
            // empty catch block
        }
        try {
            ro.getFeatureWriter("states", Transaction.AUTO_COMMIT);
            ReadOnlyDataStoreTest.fail((String)"Should have failed with a security exception");
        }
        catch (AcegiSecurityException e) {
            // empty catch block
        }
        try {
            ro.getFeatureWriter("states", (Filter)Filter.INCLUDE, Transaction.AUTO_COMMIT);
            ReadOnlyDataStoreTest.fail((String)"Should have failed with a security exception");
        }
        catch (AcegiSecurityException e) {
            // empty catch block
        }
        try {
            ro.getFeatureWriterAppend("states", Transaction.AUTO_COMMIT);
            ReadOnlyDataStoreTest.fail((String)"Should have failed with a security exception");
        }
        catch (AcegiSecurityException acegiSecurityException) {
            // empty catch block
        }
    }
}

