/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public abstract class OneTimeSetupTest
extends TestCase {
    private static boolean oneTimeSetupDone;
    private static boolean forceOneTimeTearDown;
    private boolean inSetup;
    private boolean inTearDown;

    protected abstract void oneTimeSetUp() throws Exception;

    protected abstract void oneTimeTearDown() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setUp() throws Exception {
        if (this.inSetup) {
            throw new RuntimeException("setUpInternal seems to call back to super.setUp(). It should call super.setUpInternal instead");
        }
        try {
            this.inSetup = true;
            if (!oneTimeSetupDone) {
                this.oneTimeSetUp();
                oneTimeSetupDone = true;
                forceOneTimeTearDown = true;
            }
            this.setUpInternal();
        }
        finally {
            this.inSetup = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void tearDown() throws Exception {
        if (this.inTearDown) {
            throw new RuntimeException("tearDownInternal seems to call back to super.tearDown(). It should call super.tearDownInternal instead");
        }
        try {
            this.inTearDown = true;
            this.tearDownInternal();
            if (forceOneTimeTearDown) {
                oneTimeSetupDone = false;
                forceOneTimeTearDown = false;
                this.oneTimeTearDown();
            }
        }
        finally {
            this.inTearDown = false;
        }
    }

    protected void setUpInternal() throws Exception {
    }

    protected void tearDownInternal() throws Exception {
    }

    protected static class OneTimeTestSetup
    extends TestSetup {
        private OneTimeSetupTest test;

        public OneTimeTestSetup(OneTimeSetupTest test) {
            super((Test)new TestSuite(((Object)((Object)test)).getClass()));
            this.test = test;
        }

        protected void setUp() throws Exception {
            super.setUp();
            oneTimeSetupDone = true;
            forceOneTimeTearDown = false;
            this.test.oneTimeSetUp();
        }

        protected void tearDown() throws Exception {
            super.tearDown();
            oneTimeSetupDone = false;
            forceOneTimeTearDown = false;
            this.test.oneTimeTearDown();
        }
    }
}

