/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.util.List;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.test.GeoServerTestSupport;

public class CatalogIntegrationTest
extends GeoServerTestSupport {
    public void testWorkspaceRemoveAndReadd() {
        Catalog catalog = this.getCatalog();
        NamespaceInfo defaultNamespace = catalog.getDefaultNamespace();
        WorkspaceInfo defaultWs = catalog.getDefaultWorkspace();
        List workspaces = catalog.getWorkspaces();
        CascadeDeleteVisitor visitor = new CascadeDeleteVisitor(catalog);
        for (WorkspaceInfo ws : workspaces) {
            visitor.visit(ws);
        }
        CatalogIntegrationTest.assertEquals((int)0, (int)catalog.getWorkspaces().size());
        CatalogIntegrationTest.assertEquals((int)0, (int)catalog.getNamespaces().size());
        catalog.add(defaultNamespace);
        catalog.add(defaultWs);
        CatalogIntegrationTest.assertEquals((int)1, (int)catalog.getWorkspaces().size());
        CatalogIntegrationTest.assertEquals((int)1, (int)catalog.getNamespaces().size());
        CatalogIntegrationTest.assertNotNull((Object)catalog.getNamespaceByURI(defaultNamespace.getURI()));
    }
}

