/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Properties;
import junit.framework.TestCase;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class GeoServerPropertyConfigurerTest
extends TestCase {
    ClassPathXmlApplicationContext ctx;

    protected void setUp() throws Exception {
        File f = new File("target/foo.properties");
        if (f.exists()) {
            f.delete();
        }
        this.ctx = new ClassPathXmlApplicationContext("GeoServerPropertyConfigurerTest-applicationContext.xml", ((Object)((Object)this)).getClass());
        this.ctx.refresh();
    }

    protected void tearDown() throws Exception {
        this.ctx.destroy();
    }

    public void testDefaults() {
        Foo f = (Foo)this.ctx.getBean("myBean");
        GeoServerPropertyConfigurerTest.assertEquals((String)"value1", (String)f.getBar());
        GeoServerPropertyConfigurerTest.assertEquals((String)"value2", (String)f.getBaz());
    }

    public void testUserSpecified() throws Exception {
        Properties p = new Properties();
        p.put("prop1", "foobar");
        p.put("prop2", "barfoo");
        FileOutputStream out = new FileOutputStream("target/foo.properties");
        p.store(out, "");
        out.flush();
        out.close();
        this.ctx.refresh();
        Foo f = (Foo)this.ctx.getBean("myBean");
        GeoServerPropertyConfigurerTest.assertEquals((String)"foobar", (String)f.getBar());
        GeoServerPropertyConfigurerTest.assertEquals((String)"barfoo", (String)f.getBaz());
    }

    static class Foo {
        String bar;
        String baz;

        Foo() {
        }

        public String getBar() {
            return this.bar;
        }

        public void setBar(String bar) {
            this.bar = bar;
        }

        public void setBaz(String baz) {
            this.baz = baz;
        }

        public String getBaz() {
            return this.baz;
        }
    }
}

