/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.util;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.geoserver.catalog.impl.AuthorityURL;
import org.geoserver.config.util.AuthorityURLInfoInfoListConverter;

public class AuthorityURLInfoInfoListConverterTest
extends TestCase {
    public void testFromString() {
        String serialized = "[{\"name\":\"auth1\",\"href\":\"http://geoserver.org/auth1?\"},{\"name\":\"auth2\",\"href\":\"http://geoserver.org/auth2;someparam=somevalue&\"}]";
        ArrayList<AuthorityURL> expected = new ArrayList<AuthorityURL>();
        AuthorityURL auth1 = new AuthorityURL();
        auth1.setName("auth1");
        auth1.setHref("http://geoserver.org/auth1?");
        expected.add(auth1);
        AuthorityURL auth2 = new AuthorityURL();
        auth2.setName("auth2");
        auth2.setHref("http://geoserver.org/auth2;someparam=somevalue&");
        expected.add(auth2);
        List actual = AuthorityURLInfoInfoListConverter.fromString((String)"[{\"name\":\"auth1\",\"href\":\"http://geoserver.org/auth1?\"},{\"name\":\"auth2\",\"href\":\"http://geoserver.org/auth2;someparam=somevalue&\"}]");
        AuthorityURLInfoInfoListConverterTest.assertEquals(expected, (Object)actual);
    }

    public void testFromInvalidString() {
        String serialized = "[{\"name:\"auth1\",\"href\":\"http://geoserver.org/auth1?\"},]";
        try {
            AuthorityURLInfoInfoListConverter.fromString((String)"[{\"name:\"auth1\",\"href\":\"http://geoserver.org/auth1?\"},]");
            AuthorityURLInfoInfoListConverterTest.fail((String)"Expected IAE");
        }
        catch (IllegalArgumentException e) {
            AuthorityURLInfoInfoListConverterTest.assertTrue((boolean)true);
        }
    }

    public void testToString() {
        ArrayList<AuthorityURL> list = new ArrayList<AuthorityURL>();
        AuthorityURL auth1 = new AuthorityURL();
        auth1.setName("auth1");
        auth1.setHref("http://geoserver.org/auth1?");
        list.add(auth1);
        AuthorityURL auth2 = new AuthorityURL();
        auth2.setName("auth2");
        auth2.setHref("http://geoserver.org/auth2;someparam=somevalue&");
        list.add(auth2);
        String actual = AuthorityURLInfoInfoListConverter.toString(list);
        String expected = "[{\"name\":\"auth1\",\"href\":\"http://geoserver.org/auth1?\"},{\"name\":\"auth2\",\"href\":\"http://geoserver.org/auth2;someparam=somevalue&\"}]";
        AuthorityURLInfoInfoListConverterTest.assertEquals((String)expected, (String)actual);
    }

    public void testToStringListWithNullElement() {
        ArrayList<AuthorityURL> list = new ArrayList<AuthorityURL>();
        AuthorityURL auth1 = new AuthorityURL();
        auth1.setName("auth1");
        auth1.setHref("http://geoserver.org/auth1?");
        list.add(auth1);
        list.add(null);
        String actual = AuthorityURLInfoInfoListConverter.toString(list);
        String expected = "[{\"name\":\"auth1\",\"href\":\"http://geoserver.org/auth1?\"}]";
        AuthorityURLInfoInfoListConverterTest.assertEquals((String)expected, (String)actual);
    }

    public void testToStringListWithOnlyNullElements() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(null);
        list.add(null);
        list.add(null);
        AuthorityURLInfoInfoListConverterTest.assertNull((Object)AuthorityURLInfoInfoListConverter.toString(list));
    }

    public void testToStringEmptyList() {
        ArrayList list = new ArrayList();
        String actual = AuthorityURLInfoInfoListConverter.toString(list);
        AuthorityURLInfoInfoListConverterTest.assertNull((Object)actual);
    }
}

