/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.util.Collections;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.ows.LocalWorkspaceCatalogFilter;
import org.geoserver.security.CatalogFilterAccessManager;
import org.geoserver.security.DataAccessManager;
import org.geoserver.security.DataAccessManagerAdapter;
import org.geoserver.security.ResourceAccessManager;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.impl.AbstractAuthorizationTest;

public class LocalWorkspaceSecureCatalogTest
extends AbstractAuthorizationTest {
    protected void setUp() throws Exception {
        super.setUp();
        this.populateCatalog();
    }

    public void testAccessToLayer() throws Exception {
        DataAccessManager def = this.buildLegacyAccessManager("wideOpen.properties");
        DataAccessManagerAdapter defAsResourceManager = new DataAccessManagerAdapter(def);
        CatalogFilterAccessManager mgr = new CatalogFilterAccessManager();
        mgr.setCatalogFilters(Collections.singletonList(new LocalWorkspaceCatalogFilter()));
        mgr.setDelegate((ResourceAccessManager)defAsResourceManager);
        SecureCatalogImpl sc = new SecureCatalogImpl(this.catalog, (ResourceAccessManager)mgr){};
        LocalWorkspaceSecureCatalogTest.assertNotNull((Object)sc.getLayerByName("topp:states"));
        WorkspaceInfo ws = sc.getWorkspaceByName("nurc");
        LocalWorkspace.set((WorkspaceInfo)ws);
        LocalWorkspaceSecureCatalogTest.assertNull((Object)sc.getWorkspaceByName("topp"));
        LocalWorkspaceSecureCatalogTest.assertNull((Object)sc.getResourceByName("topp:states", ResourceInfo.class));
        LocalWorkspaceSecureCatalogTest.assertNull((Object)sc.getLayerByName("topp:states"));
    }

    protected void tearDown() throws Exception {
        LocalWorkspace.remove();
    }
}

