/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl.util;

import java.io.File;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.catalog.util.LegacyCatalogImporter;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.TestData;
import org.geoserver.test.GeoServerAbstractTestSupport;

public class LegacyCatalogImporterTest
extends GeoServerAbstractTestSupport {
    private static final QName typeName = MockData.BASIC_POLYGONS;

    @Override
    protected TestData buildTestData() throws Exception {
        MockData dataDirectory = new MockData();
        dataDirectory.addWellKnownTypes(new QName[]{typeName});
        return dataDirectory;
    }

    public void testMissingFeatureTypes() throws Exception {
        MockData mockData = (MockData)this.getTestData();
        mockData.getFeatureTypesDirectory().delete();
        LegacyCatalogImporter importer = new LegacyCatalogImporter((Catalog)new CatalogImpl());
        importer.imprt(mockData.getDataDirectoryRoot());
    }

    public void testMissingCoverages() throws Exception {
        MockData mockData = (MockData)this.getTestData();
        mockData.getCoveragesDirectory().delete();
        LegacyCatalogImporter importer = new LegacyCatalogImporter((Catalog)new CatalogImpl());
        importer.imprt(mockData.getDataDirectoryRoot());
    }

    public void testCRSPrefix() throws Exception {
        MockData mockData = (MockData)this.getTestData();
        mockData.getCoveragesDirectory().delete();
        CatalogImpl catalog = new CatalogImpl();
        LegacyCatalogImporter importer = new LegacyCatalogImporter((Catalog)catalog);
        File dataDirectoryRoot = mockData.getDataDirectoryRoot();
        importer.imprt(dataDirectoryRoot);
        FeatureTypeInfo typeInfo = catalog.getFeatureTypeByName(typeName.getNamespaceURI(), typeName.getLocalPart());
        LegacyCatalogImporterTest.assertEquals((String)"EPSG:4326", (String)typeInfo.getSRS());
    }
}

