/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.lang.reflect.Proxy;
import java.util.AbstractList;
import java.util.List;

public abstract class ProxyList
extends AbstractList {
    protected List proxyList;
    protected Class proxyInterface;

    public ProxyList(List proxyList, Class proxyInterface) {
        this.proxyList = proxyList;
        this.proxyInterface = proxyInterface;
    }

    @Override
    public Object get(int index) {
        Object proxyObject = this.proxyList.get(index);
        return this.createProxy(proxyObject, this.proxyInterface);
    }

    @Override
    public Object set(int index, Object element) {
        if (!this.proxyInterface.isInstance(element) || !(element instanceof Proxy)) {
            throw new IllegalArgumentException("Object is not a proxy, or not a proxy of the correct type");
        }
        return this.proxyList.set(index, this.unwrapProxy(element, this.proxyInterface));
    }

    @Override
    public int size() {
        return this.proxyList.size();
    }

    protected abstract <T> T createProxy(T var1, Class<T> var2);

    protected abstract <T> T unwrapProxy(T var1, Class<T> var2);
}

