/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.util;

import com.vividsolutions.jts.geom.Envelope;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.geoserver.catalog.util.ReaderUtils;
import org.geoserver.ows.util.XmlCharsetDetector;
import org.w3c.dom.Element;

public class LegacyFeatureTypeInfoReader {
    Element featureType;
    File parentDirectory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(File file) throws IOException {
        this.parentDirectory = file.getParentFile();
        Reader reader = XmlCharsetDetector.getCharsetAwareReader((InputStream)new FileInputStream(file));
        try {
            this.featureType = ReaderUtils.parse(reader);
        }
        finally {
            reader.close();
        }
    }

    public String dataStore() throws Exception {
        return ReaderUtils.getAttribute(this.featureType, "datastore", true);
    }

    public String name() {
        return ReaderUtils.getChildText(this.featureType, "name");
    }

    public String alias() {
        return ReaderUtils.getChildText(this.featureType, "alias");
    }

    public String srs() throws Exception {
        return ReaderUtils.getChildText(this.featureType, "SRS");
    }

    public int srsHandling() {
        String s = ReaderUtils.getChildText(this.featureType, "SRSHandling");
        if (s == null || "".equals(s)) {
            return -1;
        }
        return Integer.parseInt(s);
    }

    public String title() {
        return ReaderUtils.getChildText(this.featureType, "title");
    }

    public String abstrct() {
        return ReaderUtils.getChildText(this.featureType, "abstract");
    }

    public List<String> keywords() {
        String raw = ReaderUtils.getChildText(this.featureType, "keywords");
        if (raw == null || "".equals(raw)) {
            return new ArrayList<String>();
        }
        StringTokenizer st = new StringTokenizer(raw, ", ");
        ArrayList<String> keywords = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            keywords.add(st.nextToken());
        }
        return keywords;
    }

    public List<Map<String, String>> metadataLinks() {
        ArrayList<Map<String, String>> links = new ArrayList<Map<String, String>>();
        Element metadataLinks = ReaderUtils.getChildElement(this.featureType, "metadataLinks");
        if (metadataLinks != null) {
            Element[] metadataLink;
            for (Element e : metadataLink = ReaderUtils.getChildElements(metadataLinks, "metadataLink")) {
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("metadataType", e.getAttribute("metadataType"));
                m.put("type", e.getAttribute("type"));
                if (e.getFirstChild() != null) {
                    m.put(null, e.getFirstChild().getNodeValue());
                }
                links.add(m);
            }
        }
        return links;
    }

    public Envelope latLonBoundingBox() throws Exception {
        Element box = ReaderUtils.getChildElement(this.featureType, "latLonBoundingBox");
        double minx = ReaderUtils.getDoubleAttribute(box, "minx", true);
        double miny = ReaderUtils.getDoubleAttribute(box, "miny", true);
        double maxx = ReaderUtils.getDoubleAttribute(box, "maxx", true);
        double maxy = ReaderUtils.getDoubleAttribute(box, "maxy", true);
        return new Envelope(minx, maxx, miny, maxy);
    }

    public Envelope nativeBoundingBox() throws Exception {
        Element box = ReaderUtils.getChildElement(this.featureType, "nativeBBox");
        boolean dynamic = ReaderUtils.getBooleanAttribute(box, "dynamic", false, true);
        if (dynamic) {
            return null;
        }
        double minx = ReaderUtils.getDoubleAttribute(box, "minx", true);
        double miny = ReaderUtils.getDoubleAttribute(box, "miny", true);
        double maxx = ReaderUtils.getDoubleAttribute(box, "maxx", true);
        double maxy = ReaderUtils.getDoubleAttribute(box, "maxy", true);
        return new Envelope(minx, maxx, miny, maxy);
    }

    public String defaultStyle() throws Exception {
        Element styles = ReaderUtils.getChildElement(this.featureType, "styles");
        return ReaderUtils.getAttribute(styles, "default", false);
    }

    public List<String> styles() throws Exception {
        Element styleRoot = ReaderUtils.getChildElement(this.featureType, "styles");
        if (styleRoot != null) {
            Element[] styles;
            ArrayList<String> styleNames = new ArrayList<String>();
            for (Element style : styles = ReaderUtils.getChildElements(styleRoot, "style")) {
                styleNames.add(style.getTextContent().trim());
            }
            return styleNames;
        }
        return Collections.emptyList();
    }

    public Map<String, Object> legendURL() throws Exception {
        Element legendURL = ReaderUtils.getChildElement(this.featureType, "LegendURL");
        if (legendURL != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("width", ReaderUtils.getAttribute(legendURL, "width", true));
            map.put("height", Integer.parseInt(ReaderUtils.getAttribute(legendURL, "height", true)));
            map.put("format", ReaderUtils.getChildText(legendURL, "Format", true));
            map.put("onlineResource", ReaderUtils.getAttribute(ReaderUtils.getChildElement(legendURL, "OnlineResource", true), "xlink:href", true));
            return map;
        }
        return null;
    }

    public boolean cachingEnabled() {
        Element cacheInfo = ReaderUtils.getChildElement(this.featureType, "cacheinfo");
        if (cacheInfo != null) {
            try {
                return "true".equals(ReaderUtils.getAttribute(cacheInfo, "enabled", false));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public String cacheAgeMax() {
        Element cacheInfo = ReaderUtils.getChildElement(this.featureType, "cacheinfo");
        if (cacheInfo != null) {
            try {
                return ReaderUtils.getAttribute(cacheInfo, "maxage", false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean searchable() {
        Element searchable = ReaderUtils.getChildElement(this.featureType, "searchable");
        if (searchable != null) {
            try {
                return "true".equals(ReaderUtils.getAttribute(searchable, "enabled", false));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public String regionateAttribute() {
        Element regionateAttribute = ReaderUtils.getChildElement(this.featureType, "regionateAttribute");
        if (regionateAttribute != null) {
            return regionateAttribute.getAttribute("value");
        }
        return null;
    }

    public String regionateStrategy() {
        Element regionateStrategy = ReaderUtils.getChildElement(this.featureType, "regionateStrategy");
        if (regionateStrategy != null) {
            return regionateStrategy.getAttribute("value");
        }
        return null;
    }

    public int regionateFeatureLimit() {
        Element regionateFeatureLimit = ReaderUtils.getChildElement(this.featureType, "regionateFeatureLimit");
        try {
            return Integer.valueOf(regionateFeatureLimit.getAttribute("value"));
        }
        catch (Exception e) {
            return 10;
        }
    }

    public int maxFeatures() {
        Element maxFeatures = ReaderUtils.getChildElement(this.featureType, "maxFeatures");
        try {
            return Integer.valueOf(maxFeatures.getTextContent());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String wmsPath() {
        return ReaderUtils.getChildText(this.featureType, "wmspath");
    }

    public String parentDirectoryName() {
        return this.parentDirectory.getName();
    }
}

