/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.platform.GeoServerResourceLoader;

public class GeoServerDataDirectory {
    GeoServerResourceLoader resourceLoader;

    public GeoServerDataDirectory(GeoServerResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public GeoServerDataDirectory(File baseDirectory) {
        this(new GeoServerResourceLoader(baseDirectory));
    }

    public File root() {
        return this.resourceLoader.getBaseDirectory();
    }

    public File findDataRoot() throws IOException {
        return this.dataRoot(false);
    }

    public File findOrCreateDataRoot() throws IOException {
        return this.dataRoot(false);
    }

    File dataRoot(boolean create) throws IOException {
        return create ? this.resourceLoader.findOrCreateDirectory("data") : this.resourceLoader.find("data");
    }

    public File findDataDir(String ... location) throws IOException {
        return this.dataDir(false, location);
    }

    public File findOrCreateDataDir(String ... location) throws IOException {
        return this.dataDir(true, location);
    }

    protected File dataDir(boolean create, String ... location) throws IOException {
        return create ? this.resourceLoader.findOrCreateDirectory(this.dataRoot(create), location) : this.resourceLoader.find(this.dataRoot(create), location);
    }

    public File findDataFile(String ... location) throws IOException {
        return this.dataFile(false, location);
    }

    public File findOrResolveDataFile(String ... location) throws IOException {
        return this.dataFile(true, location);
    }

    File dataFile(boolean create, String ... location) throws IOException {
        return create ? this.resourceLoader.createFile(this.dataRoot(create), location) : this.resourceLoader.find(this.dataRoot(create), location);
    }

    public File findWorkspaceDir(WorkspaceInfo ws) throws IOException {
        return this.workspaceDir(false, ws);
    }

    public File findOrCreateWorkspaceDir(WorkspaceInfo ws) throws IOException {
        return this.workspaceDir(true, ws);
    }

    File workspaceDir(boolean create, WorkspaceInfo ws) throws IOException {
        File workspaces;
        File file = workspaces = create ? this.resourceLoader.findOrCreateDirectory("workspaces") : this.resourceLoader.find("workspaces");
        if (workspaces != null) {
            return this.dir(new File(workspaces, ws.getName()), create);
        }
        return null;
    }

    public File findWorkspaceFile(WorkspaceInfo ws) throws IOException {
        return this.workspaceFile(false, ws);
    }

    public File findOrResolveWorkspaceFile(WorkspaceInfo ws) throws IOException {
        return this.workspaceFile(true, ws);
    }

    File workspaceFile(boolean create, WorkspaceInfo ws) throws IOException {
        File wsdir = this.workspaceDir(create, ws);
        return wsdir != null ? this.file(new File(wsdir, "workspace.xml"), create) : null;
    }

    public File findSuppWorkspaceFile(WorkspaceInfo ws, String filename) throws IOException {
        File wsdir = this.findWorkspaceDir(ws);
        return wsdir != null ? this.file(new File(wsdir, filename), false) : null;
    }

    public void copyToWorkspaceDir(WorkspaceInfo ws, File f) throws IOException {
        FileUtils.copyFileToDirectory((File)f, (File)this.workspaceDir(true, ws));
    }

    public void copyToWorkspaceDir(WorkspaceInfo ws, InputStream data, String filename) throws IOException {
        this.copy(data, this.workspaceDir(true, ws), filename);
    }

    public File findStoreDir(StoreInfo s) throws IOException {
        return this.storeDir(false, s);
    }

    public File findOrCreateStoreDir(StoreInfo s) throws IOException {
        return this.storeDir(true, s);
    }

    File storeDir(boolean create, StoreInfo s) throws IOException {
        File wsdir = this.workspaceDir(create, s.getWorkspace());
        return wsdir != null ? this.dir(new File(wsdir, s.getName()), create) : null;
    }

    public File findStoreFile(StoreInfo s) throws IOException {
        return this.storeFile(false, s);
    }

    public File findOrResolveStoreFile(StoreInfo s) throws IOException {
        return this.storeFile(true, s);
    }

    File storeFile(boolean create, StoreInfo s) throws IOException {
        File sdir = this.storeDir(create, s);
        if (sdir == null) {
            return null;
        }
        if (s instanceof DataStoreInfo) {
            return this.file(new File(sdir, "datastore.xml"), create);
        }
        if (s instanceof CoverageStoreInfo) {
            return this.file(new File(sdir, "coveragestore.xml"), create);
        }
        return null;
    }

    public File findSuppStoreFile(StoreInfo ws, String filename) throws IOException {
        File sdir = this.findStoreDir(ws);
        return sdir != null ? this.file(new File(sdir, filename), false) : null;
    }

    public void copyToStoreDir(StoreInfo s, File f) throws IOException {
        FileUtils.copyFileToDirectory((File)f, (File)this.storeDir(true, s));
    }

    public void copyToStoreDir(StoreInfo s, InputStream data, String filename) throws IOException {
        this.copy(data, this.storeDir(true, s), filename);
    }

    public File findResourceDir(ResourceInfo r) throws IOException {
        return this.resourceDir(false, r);
    }

    public File findOrCreateResourceDir(ResourceInfo r) throws IOException {
        return this.resourceDir(true, r);
    }

    File resourceDir(boolean create, ResourceInfo r) throws IOException {
        File sdir = this.storeDir(create, r.getStore());
        return sdir != null ? this.dir(new File(sdir, r.getName()), create) : null;
    }

    public File findResourceFile(ResourceInfo r) throws IOException {
        return this.resourceFile(false, r);
    }

    public File findOrResolveResourceFile(ResourceInfo r) throws IOException {
        return this.resourceFile(true, r);
    }

    File resourceFile(boolean create, ResourceInfo r) throws IOException {
        File rdir = this.resourceDir(create, r);
        if (rdir == null) {
            return null;
        }
        if (r instanceof FeatureTypeInfo) {
            return this.file(new File(rdir, "featuretype.xml"), create);
        }
        if (r instanceof CoverageInfo) {
            return this.file(new File(rdir, "coverage"), create);
        }
        return null;
    }

    public File findSuppResourceFile(ResourceInfo r, String filename) throws IOException {
        File rdir = this.findResourceDir(r);
        return rdir != null ? this.file(new File(rdir, filename), false) : null;
    }

    public void copyToResourceDir(ResourceInfo r, File f) throws IOException {
        FileUtils.copyFileToDirectory((File)f, (File)this.resourceDir(true, r));
    }

    public void copyToResourceDir(ResourceInfo r, InputStream data, String filename) throws IOException {
        this.copy(data, this.resourceDir(true, r), filename);
    }

    public File findNamespaceFile(WorkspaceInfo ws) throws IOException {
        return this.workspaceDir(false, ws);
    }

    public File findOrResolveNamespaceFile(WorkspaceInfo ws) throws IOException {
        return this.workspaceDir(true, ws);
    }

    File namespaceFile(boolean create, WorkspaceInfo ws) throws IOException {
        File wsdir = this.workspaceDir(create, ws);
        return wsdir != null ? this.file(new File(wsdir, "namespace.xml"), create) : null;
    }

    public File findLayerFile(LayerInfo l) throws IOException {
        return this.layerFile(false, l);
    }

    public File findOrResolveLayerFile(LayerInfo l) throws IOException {
        return this.layerFile(true, l);
    }

    File layerFile(boolean create, LayerInfo l) throws IOException {
        File rdir = this.resourceDir(create, l.getResource());
        return rdir != null ? this.file(new File(rdir, "layer.xml"), create) : null;
    }

    public File findStyleDir() throws IOException {
        return this.styleDir(false);
    }

    public File findOrCreateStyleDir() throws IOException {
        return this.styleDir(true);
    }

    File styleDir(boolean create) throws IOException {
        return create ? this.resourceLoader.findOrCreateDirectory("styles") : this.resourceLoader.find("styles");
    }

    public File findStyleFile(StyleInfo s) throws IOException {
        return this.styleFile(false, s);
    }

    public File findOrCreateStyleFile(StyleInfo s) throws IOException {
        return this.styleFile(true, s);
    }

    File styleFile(boolean create, StyleInfo s) throws IOException {
        File sdir = this.styleDir(create);
        return sdir != null ? this.file(new File(sdir, s.getName() + ".xml"), create) : null;
    }

    public void copyToStyleDir(File f) throws IOException {
        FileUtils.copyFileToDirectory((File)f, (File)this.styleDir(true));
    }

    public void copyToStyleDir(InputStream data, String filename) throws IOException {
        this.copy(data, this.styleDir(true), filename);
    }

    void copy(InputStream data, File targetDir, String filename) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(targetDir, filename)));
        IOUtils.copy((InputStream)data, (OutputStream)out);
        out.flush();
        out.close();
    }

    File file(File f) {
        return this.file(f, true);
    }

    File file(File f, boolean create) {
        if (create) {
            return f;
        }
        return f.exists() ? f : null;
    }

    File dir(File d, boolean create) {
        if (create) {
            d.mkdirs();
            return d;
        }
        return d.exists() ? d : null;
    }
}

