/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.util;

import java.util.List;
import java.util.Map;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.ServiceLoader;
import org.geoserver.config.util.LegacyServicesReader;

public abstract class LegacyServiceLoader<T extends ServiceInfo>
implements ServiceLoader<T> {
    LegacyServicesReader reader;

    public void setReader(LegacyServicesReader reader) {
        this.reader = reader;
    }

    @Override
    public final T load(GeoServer gs) throws Exception {
        return this.load(this.reader, gs);
    }

    public abstract T load(LegacyServicesReader var1, GeoServer var2) throws Exception;

    protected void readCommon(ServiceInfo service, Map<String, Object> properties, GeoServer gs) throws Exception {
        List keywords;
        service.setEnabled((Boolean)properties.get("enabled"));
        service.setName((String)properties.get("name"));
        service.setTitle((String)properties.get("title"));
        service.setAbstract((String)properties.get("abstract"));
        Map metadataLink = (Map)properties.get("metadataLink");
        if (metadataLink != null) {
            MetadataLinkInfo ml = gs.getCatalog().getFactory().createMetadataLink();
            ml.setAbout((String)metadataLink.get("about"));
            ml.setMetadataType((String)metadataLink.get("metadataType"));
            ml.setType((String)metadataLink.get("type"));
            service.setMetadataLink(ml);
        }
        if ((keywords = (List)properties.get("keywords")) != null) {
            service.getKeywords().addAll(keywords);
        }
        service.setOnlineResource((String)properties.get("onlineResource"));
        service.setFees((String)properties.get("fees"));
        service.setAccessConstraints((String)properties.get("accessConstraints"));
        service.setCiteCompliant((Boolean)properties.get("citeConformanceHacks"));
        service.setMaintainer((String)properties.get("maintainer"));
        service.setSchemaBaseURL((String)properties.get("SchemaBaseUrl"));
    }

    @Override
    public void save(T service, GeoServer gs) throws Exception {
    }
}

