/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.feature.retype;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.geoserver.feature.RetypingFeatureCollection;
import org.geoserver.feature.retype.FeatureTypeMap;
import org.geoserver.feature.retype.RetypingDataStore;
import org.geoserver.feature.retype.RetypingFeatureSource;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.feature.FeatureCollection;
import org.geotools.util.Converters;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.identity.FeatureId;

public class RetypingFeatureStore
extends RetypingFeatureSource
implements FeatureStore<SimpleFeatureType, SimpleFeature> {
    public RetypingFeatureStore(RetypingDataStore ds, FeatureStore<SimpleFeatureType, SimpleFeature> wrapped, FeatureTypeMap typeMap) {
        super(ds, (FeatureSource<SimpleFeatureType, SimpleFeature>)wrapped, typeMap);
    }

    protected FeatureStore<SimpleFeatureType, SimpleFeature> featureStore() {
        return (FeatureStore)this.wrapped;
    }

    public Transaction getTransaction() {
        return this.featureStore().getTransaction();
    }

    public void setTransaction(Transaction transaction) {
        this.featureStore().setTransaction(transaction);
    }

    public void modifyFeatures(AttributeDescriptor type, Object value, Filter filter) throws IOException {
        this.modifyFeatures(new AttributeDescriptor[]{type}, new Object[]{value}, filter);
    }

    public void removeFeatures(Filter filter) throws IOException {
        this.featureStore().removeFeatures(this.store.retypeFilter(filter, this.typeMap));
    }

    public void modifyFeatures(AttributeDescriptor[] type, Object[] values, Filter filter) throws IOException {
        SimpleFeatureType schema = this.getSchema();
        SimpleFeatureType original = this.store.getTypeMapBackwards((String)schema.getTypeName(), (boolean)true).originalFeatureType;
        AttributeDescriptor[] originalTypes = new AttributeDescriptor[type.length];
        Object[] originalValues = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            originalTypes[i] = original.getDescriptor(type[i].getName());
            if (values[i] == null) continue;
            Class target = originalTypes[i].getType().getBinding();
            originalValues[i] = Converters.convert((Object)values[i], (Class)target);
            if (originalValues[i] != null) continue;
            throw new IOException("Could not map back " + values[i] + " to type " + target);
        }
        this.featureStore().modifyFeatures(originalTypes, originalValues, this.store.retypeFilter(filter, this.typeMap));
    }

    public void setFeatures(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        RetypingFeatureCollection.RetypingFeatureReader retypingFeatureReader = new RetypingFeatureCollection.RetypingFeatureReader(reader, this.typeMap.getOriginalFeatureType());
        this.featureStore().setFeatures((FeatureReader)retypingFeatureReader);
    }

    public List<FeatureId> addFeatures(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) throws IOException {
        List ids = this.featureStore().addFeatures((FeatureCollection)new RetypingFeatureCollection(collection, this.typeMap.getOriginalFeatureType()));
        ArrayList<FeatureId> retyped = new ArrayList<FeatureId>();
        for (FeatureId id : ids) {
            retyped.add(RetypingFeatureCollection.reTypeId(id, this.typeMap.getOriginalFeatureType(), this.typeMap.getFeatureType()));
        }
        return retyped;
    }
}

