/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.logging;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.RollingFileAppender;
import org.geoserver.logging.LoggingInitializer;
import org.geoserver.platform.GeoServerResourceLoader;
import org.vfny.geoserver.global.ConfigurationException;

public class LoggingUtils {
    public static final String RELINQUISH_LOG4J_CONTROL = "RELINQUISH_LOG4J_CONTROL";
    public static final String GT2_LOGGING_REDIRECTION = "GT2_LOGGING_REDIRECTION";

    public static void configureGeoServerLogging(GeoServerResourceLoader loader, InputStream loggingConfigStream, boolean suppressStdOutLogging, boolean suppressFileLogging, String logFileName) throws FileNotFoundException, IOException, ConfigurationException {
        ArrayList<Appender> appenders = new ArrayList<Appender>();
        Enumeration a = LogManager.getRootLogger().getAllAppenders();
        while (a.hasMoreElements()) {
            Appender appender = (Appender)a.nextElement();
            if (appender instanceof ConsoleAppender || appender instanceof FileAppender) continue;
            appenders.add(appender);
        }
        Properties lprops = new Properties();
        lprops.load(loggingConfigStream);
        LogManager.resetConfiguration();
        PropertyConfigurator.configure((Properties)lprops);
        if (!suppressFileLogging) {
            Appender gslf = Logger.getRootLogger().getAppender("geoserverlogfile");
            if (gslf instanceof RollingFileAppender) {
                if (logFileName == null) {
                    logFileName = new File(loader.findOrCreateDirectory("logs"), "geoserver.log").getAbsolutePath();
                } else if (!new File(logFileName).isAbsolute()) {
                    logFileName = new File(loader.getBaseDirectory(), logFileName).getAbsolutePath();
                    LoggingInitializer.LOGGER.fine("Non-absolute pathname detected for logfile.  Setting logfile relative to data dir.");
                }
                lprops.setProperty("log4j.appender.geoserverlogfile.File", logFileName);
                PropertyConfigurator.configure((Properties)lprops);
                LoggingInitializer.LOGGER.fine("Logging output to file '" + logFileName + "'");
            } else if (gslf != null) {
                LoggingInitializer.LOGGER.warning("'log4j.appender.geoserverlogfile' appender is defined, but isn't a RollingFileAppender.  GeoServer won't control the file-based logging.");
            } else {
                LoggingInitializer.LOGGER.warning("'log4j.appender.geoserverlogfile' appender isn't defined.  GeoServer won't control the file-based logging.");
            }
        }
        if (suppressStdOutLogging) {
            LoggingInitializer.LOGGER.warning("Suppressing StdOut logging.  If you want to see GeoServer logs, be sure to look in '" + logFileName + "'");
            Enumeration allAppenders = Logger.getRootLogger().getAllAppenders();
            while (allAppenders.hasMoreElements()) {
                Appender curApp = (Appender)allAppenders.nextElement();
                if (!(curApp instanceof ConsoleAppender)) continue;
                Logger.getRootLogger().removeAppender(curApp);
            }
        }
        for (Appender appender : appenders) {
            LogManager.getRootLogger().addAppender(appender);
        }
        LoggingInitializer.LOGGER.fine("FINISHED CONFIGURING GEOSERVER LOGGING -------------------------");
    }

    public static void initLogging(GeoServerResourceLoader resourceLoader, String configFileName, boolean suppressStdOutLogging, String logFileName) throws Exception {
        File log4jConfigFile;
        LoggingInitializer.LOGGER.fine("CONFIGURING GEOSERVER LOGGING -------------------------");
        if (configFileName == null) {
            configFileName = "DEFAULT_LOGGING.properties";
            LoggingInitializer.LOGGER.warning("No log4jConfigFile defined in services.xml:  using 'DEFAULT_LOGGING.properties'");
        }
        if ((log4jConfigFile = resourceLoader.find(new String[]{"logs", configFileName})) == null) {
            LoggingInitializer.LOGGER.warning("log4jConfigFile '" + configFileName + "' couldn't be found in the data dir, so GeoServer will " + "install the various logging config file into the data dir, and then try to find it again.");
            File lcdir = resourceLoader.findOrCreateDirectory("logs");
            String[] lcfiles = new String[]{"DEFAULT_LOGGING.properties", "VERBOSE_LOGGING.properties", "PRODUCTION_LOGGING.properties", "GEOTOOLS_DEVELOPER_LOGGING.properties", "GEOSERVER_DEVELOPER_LOGGING.properties"};
            for (int i = 0; i < lcfiles.length; ++i) {
                File target = new File(lcdir.getAbsolutePath(), lcfiles[i]);
                if (target.exists()) continue;
                resourceLoader.copyFromClassPath(lcfiles[i], target);
            }
            log4jConfigFile = resourceLoader.find(new String[]{"logs", configFileName});
            if (log4jConfigFile == null) {
                LoggingInitializer.LOGGER.warning("Still couldn't find log4jConfigFile '" + configFileName + "'.  Using DEFAULT_LOGGING.properties instead.");
            }
            log4jConfigFile = resourceLoader.find(new String[]{"logs", "DEFAULT_LOGGING.properties"});
        }
        if (log4jConfigFile == null || !log4jConfigFile.exists()) {
            throw new ConfigurationException("Unable to load logging configuration '" + configFileName + "'.  In addition, an attempt " + "was made to create the 'logs' directory in your data dir, and to use the DEFAULT_LOGGING configuration, but" + "this failed as well.  Is your data dir writeable?");
        }
        FileInputStream loggingConfigStream = new FileInputStream(log4jConfigFile);
        if (loggingConfigStream == null) {
            LoggingInitializer.LOGGER.warning("Couldn't open Log4J configuration file '" + log4jConfigFile.getAbsolutePath());
            return;
        }
        LoggingInitializer.LOGGER.fine("GeoServer logging profile '" + log4jConfigFile.getName() + "' enabled.");
        LoggingUtils.configureGeoServerLogging(resourceLoader, loggingConfigStream, suppressStdOutLogging, false, logFileName);
    }

    public static enum GeoToolsLoggingRedirection {
        JavaLogging,
        CommonsLogging,
        Log4J;


        public static GeoToolsLoggingRedirection findValue(String name) {
            for (GeoToolsLoggingRedirection value : GeoToolsLoggingRedirection.values()) {
                if (!value.name().equalsIgnoreCase(name)) continue;
                return value;
            }
            return Log4J;
        }
    }
}

