/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.test.GeoServerTestSupport;

public class SchemaMappingTest
extends GeoServerTestSupport {
    public void testNoMapping() throws Exception {
        FeatureTypeInfo ft = this.getCatalog().getFeatureTypeByName("DividedRoutes");
        SchemaMappingTest.assertEquals((int)4, (int)ft.attributes().size());
    }

    public void testXsdMapping() throws Exception {
        ((MockData)testData).copyToFeatureTypeDirectory(((Object)((Object)this)).getClass().getResourceAsStream("schema.xsd"), MockData.DIVIDED_ROUTES, "schema.xsd");
        this.reloadCatalogAndConfiguration();
        FeatureTypeInfo ft = this.getCatalog().getFeatureTypeByName("DividedRoutes");
        SchemaMappingTest.assertEquals((int)3, (int)ft.attributes().size());
    }

    public void testXmlMapping() throws Exception {
        ((MockData)testData).copyToFeatureTypeDirectory(((Object)((Object)this)).getClass().getResourceAsStream("schema.xml"), MockData.DIVIDED_ROUTES, "schema.xml");
        this.reloadCatalogAndConfiguration();
        FeatureTypeInfo ft = this.getCatalog().getFeatureTypeByName("DividedRoutes");
        SchemaMappingTest.assertEquals((int)2, (int)ft.attributes().size());
    }
}

