/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.geoserver.config.ConfigurationListener;
import org.geoserver.config.ConfigurationListenerAdapter;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.impl.GeoServerImpl;
import org.geoserver.config.impl.ServiceInfoImpl;

public class GeoServerImplTest
extends TestCase {
    GeoServerImpl geoServer;

    protected void setUp() throws Exception {
        super.setUp();
        this.geoServer = new GeoServerImpl();
    }

    public void testGlobal() throws Exception {
        GeoServerInfo global = this.geoServer.getFactory().createGlobal();
        this.geoServer.setGlobal(global);
        GeoServerImplTest.assertEquals((Object)global, (Object)this.geoServer.getGlobal());
    }

    public void testModifyGlobal() throws Exception {
        GeoServerInfo global = this.geoServer.getFactory().createGlobal();
        this.geoServer.setGlobal(global);
        GeoServerInfo g1 = this.geoServer.getGlobal();
        g1.setAdminPassword("newAdminPassword");
        GeoServerInfo g2 = this.geoServer.getGlobal();
        GeoServerImplTest.assertNull((Object)g2.getAdminPassword());
        this.geoServer.save(g1);
        g2 = this.geoServer.getGlobal();
        GeoServerImplTest.assertEquals((String)"newAdminPassword", (String)g2.getAdminPassword());
    }

    public void testAddService() throws Exception {
        ServiceInfo service = this.geoServer.getFactory().createService();
        service.setName("foo");
        try {
            this.geoServer.add(service);
            GeoServerImplTest.fail((String)"adding without id should throw exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        ((ServiceInfoImpl)service).setId("id");
        this.geoServer.add(service);
        ServiceInfo s2 = this.geoServer.getFactory().createService();
        ((ServiceInfoImpl)s2).setId("id");
        try {
            this.geoServer.add(s2);
            GeoServerImplTest.fail((String)"adding service with duplicate id should throw exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        ServiceInfo s = this.geoServer.getServiceByName("foo", ServiceInfo.class);
        GeoServerImplTest.assertTrue((s != service ? 1 : 0) != 0);
        GeoServerImplTest.assertEquals((Object)service, (Object)s);
    }

    public void testModifyService() throws Exception {
        ServiceInfo service = this.geoServer.getFactory().createService();
        ((ServiceInfoImpl)service).setId("id");
        service.setName("foo");
        service.setTitle("bar");
        this.geoServer.add(service);
        ServiceInfo s1 = this.geoServer.getServiceByName("foo", ServiceInfo.class);
        s1.setTitle("changed");
        ServiceInfo s2 = this.geoServer.getServiceByName("foo", ServiceInfo.class);
        GeoServerImplTest.assertEquals((String)"bar", (String)s2.getTitle());
        this.geoServer.save(s1);
        GeoServerImplTest.assertEquals((String)"changed", (String)s2.getTitle());
    }

    public void testGlobalEvents() throws Exception {
        TestListener tl = new TestListener();
        this.geoServer.addListener((ConfigurationListener)tl);
        GeoServerInfo global = this.geoServer.getFactory().createGlobal();
        this.geoServer.setGlobal(global);
        global = this.geoServer.getGlobal();
        global.setAdminPassword("foo");
        global.setOnlineResource("bar");
        GeoServerImplTest.assertEquals((int)0, (int)tl.gPropertyNames.size());
        this.geoServer.save(global);
        GeoServerImplTest.assertEquals((int)2, (int)tl.gPropertyNames.size());
        GeoServerImplTest.assertTrue((boolean)tl.gPropertyNames.contains("adminPassword"));
        GeoServerImplTest.assertTrue((boolean)tl.gPropertyNames.contains("onlineResource"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestListener
    extends ConfigurationListenerAdapter {
        List<String> gPropertyNames = new ArrayList<String>();
        List<Object> gOldValues = new ArrayList<Object>();
        List<Object> gNewValues = new ArrayList<Object>();
        List<String> sPropertyNames = new ArrayList<String>();
        List<Object> sOldValues = new ArrayList<Object>();
        List<Object> sNewValues = new ArrayList<Object>();

        TestListener() {
        }

        public void handleGlobalChange(GeoServerInfo global, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
            this.gPropertyNames.addAll(propertyNames);
            this.gOldValues.addAll(oldValues);
            this.gNewValues.addAll(newValues);
        }

        public void handleServiceChange(ServiceInfo service, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
            this.sPropertyNames.addAll(propertyNames);
            this.sOldValues.addAll(oldValues);
            this.sNewValues.addAll(newValues);
        }
    }
}

