/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import org.acegisecurity.Authentication;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.security.AbstractAuthorizationTest;
import org.geoserver.security.AccessMode;
import org.geoserver.security.DataAccessManager;

public class DefaultDataAccessManagerAuthTest
extends AbstractAuthorizationTest {
    public void testWideOpen() throws Exception {
        DataAccessManager manager = this.buildManager("wideOpen.properties");
        this.checkUserAccessFlat(manager, this.anonymous, true, true);
    }

    public void testLockedDown() throws Exception {
        DataAccessManager manager = this.buildManager("lockedDown.properties");
        this.checkUserAccessFlat(manager, this.anonymous, false, false);
        this.checkUserAccessFlat(manager, this.roUser, false, false);
        this.checkUserAccessFlat(manager, this.rwUser, true, true);
        this.checkUserAccessFlat(manager, (Authentication)this.root, true, true);
    }

    public void testPublicRead() throws Exception {
        DataAccessManager manager = this.buildManager("publicRead.properties");
        this.checkUserAccessFlat(manager, this.anonymous, true, false);
        this.checkUserAccessFlat(manager, this.roUser, true, false);
        this.checkUserAccessFlat(manager, this.rwUser, true, true);
        this.checkUserAccessFlat(manager, (Authentication)this.root, true, true);
    }

    private void checkUserAccessFlat(DataAccessManager manager, Authentication user, boolean expectedRead, boolean expectedWrite) {
        DefaultDataAccessManagerAuthTest.assertEquals((boolean)expectedRead, (boolean)manager.canAccess(user, this.statesLayer, AccessMode.READ));
        DefaultDataAccessManagerAuthTest.assertEquals((boolean)expectedWrite, (boolean)manager.canAccess(user, this.statesLayer, AccessMode.WRITE));
        ResourceInfo resource = this.statesLayer.getResource();
        DefaultDataAccessManagerAuthTest.assertEquals((boolean)expectedRead, (boolean)manager.canAccess(user, resource, AccessMode.READ));
        DefaultDataAccessManagerAuthTest.assertEquals((boolean)expectedWrite, (boolean)manager.canAccess(user, resource, AccessMode.WRITE));
        DefaultDataAccessManagerAuthTest.assertEquals((boolean)expectedRead, (boolean)manager.canAccess(user, this.toppWs, AccessMode.READ));
        DefaultDataAccessManagerAuthTest.assertEquals((boolean)expectedWrite, (boolean)manager.canAccess(user, this.toppWs, AccessMode.WRITE));
    }

    public void testComplex() throws Exception {
        DataAccessManager wo = this.buildManager("complex.properties");
        DefaultDataAccessManagerAuthTest.assertFalse((boolean)wo.canAccess(this.anonymous, this.nurcWs, AccessMode.READ));
        DefaultDataAccessManagerAuthTest.assertFalse((boolean)wo.canAccess(this.anonymous, this.nurcWs, AccessMode.WRITE));
        DefaultDataAccessManagerAuthTest.assertTrue((boolean)wo.canAccess(this.roUser, this.nurcWs, AccessMode.READ));
        DefaultDataAccessManagerAuthTest.assertFalse((boolean)wo.canAccess(this.rwUser, this.nurcWs, AccessMode.WRITE));
        DefaultDataAccessManagerAuthTest.assertTrue((boolean)wo.canAccess((Authentication)this.root, this.nurcWs, AccessMode.WRITE));
        DefaultDataAccessManagerAuthTest.assertTrue((boolean)wo.canAccess(this.anonymous, this.toppWs, AccessMode.READ));
        DefaultDataAccessManagerAuthTest.assertFalse((boolean)wo.canAccess(this.anonymous, this.toppWs, AccessMode.WRITE));
        DefaultDataAccessManagerAuthTest.assertTrue((boolean)wo.canAccess(this.roUser, this.toppWs, AccessMode.READ));
        DefaultDataAccessManagerAuthTest.assertFalse((boolean)wo.canAccess(this.rwUser, this.toppWs, AccessMode.WRITE));
        DefaultDataAccessManagerAuthTest.assertTrue((boolean)wo.canAccess(this.anonymous, this.roadsLayer, AccessMode.READ));
        DefaultDataAccessManagerAuthTest.assertFalse((boolean)wo.canAccess(this.anonymous, this.roadsLayer, AccessMode.WRITE));
        DefaultDataAccessManagerAuthTest.assertTrue((boolean)wo.canAccess(this.roUser, this.roadsLayer, AccessMode.READ));
        DefaultDataAccessManagerAuthTest.assertFalse((boolean)wo.canAccess(this.rwUser, this.roadsLayer, AccessMode.WRITE));
        DefaultDataAccessManagerAuthTest.assertFalse((boolean)wo.canAccess(this.anonymous, this.statesLayer, AccessMode.READ));
        DefaultDataAccessManagerAuthTest.assertFalse((boolean)wo.canAccess(this.anonymous, this.statesLayer, AccessMode.WRITE));
        DefaultDataAccessManagerAuthTest.assertTrue((boolean)wo.canAccess(this.roUser, this.statesLayer, AccessMode.READ));
        DefaultDataAccessManagerAuthTest.assertFalse((boolean)wo.canAccess(this.roUser, this.statesLayer, AccessMode.WRITE));
        DefaultDataAccessManagerAuthTest.assertTrue((boolean)wo.canAccess(this.rwUser, this.statesLayer, AccessMode.WRITE));
        DefaultDataAccessManagerAuthTest.assertTrue((boolean)wo.canAccess(this.rwUser, this.statesLayer, AccessMode.WRITE));
        DefaultDataAccessManagerAuthTest.assertTrue((boolean)wo.canAccess(this.anonymous, this.landmarksLayer, AccessMode.READ));
        DefaultDataAccessManagerAuthTest.assertFalse((boolean)wo.canAccess(this.anonymous, this.landmarksLayer, AccessMode.WRITE));
        DefaultDataAccessManagerAuthTest.assertTrue((boolean)wo.canAccess(this.roUser, this.landmarksLayer, AccessMode.READ));
        DefaultDataAccessManagerAuthTest.assertFalse((boolean)wo.canAccess(this.roUser, this.landmarksLayer, AccessMode.WRITE));
        DefaultDataAccessManagerAuthTest.assertTrue((boolean)wo.canAccess(this.rwUser, this.landmarksLayer, AccessMode.READ));
        DefaultDataAccessManagerAuthTest.assertTrue((boolean)wo.canAccess(this.rwUser, this.statesLayer, AccessMode.WRITE));
        DefaultDataAccessManagerAuthTest.assertFalse((boolean)wo.canAccess(this.anonymous, this.basesLayer, AccessMode.READ));
        DefaultDataAccessManagerAuthTest.assertFalse((boolean)wo.canAccess(this.anonymous, this.basesLayer, AccessMode.WRITE));
        DefaultDataAccessManagerAuthTest.assertFalse((boolean)wo.canAccess(this.roUser, this.basesLayer, AccessMode.READ));
        DefaultDataAccessManagerAuthTest.assertFalse((boolean)wo.canAccess(this.roUser, this.basesLayer, AccessMode.WRITE));
        DefaultDataAccessManagerAuthTest.assertFalse((boolean)wo.canAccess(this.rwUser, this.basesLayer, AccessMode.READ));
        DefaultDataAccessManagerAuthTest.assertFalse((boolean)wo.canAccess(this.rwUser, this.basesLayer, AccessMode.WRITE));
        DefaultDataAccessManagerAuthTest.assertTrue((boolean)wo.canAccess(this.milUser, this.basesLayer, AccessMode.READ));
        DefaultDataAccessManagerAuthTest.assertTrue((boolean)wo.canAccess(this.milUser, this.basesLayer, AccessMode.WRITE));
        DefaultDataAccessManagerAuthTest.assertFalse((boolean)wo.canAccess(this.anonymous, this.arcGridLayer, AccessMode.READ));
        DefaultDataAccessManagerAuthTest.assertFalse((boolean)wo.canAccess(this.anonymous, this.arcGridLayer, AccessMode.WRITE));
        DefaultDataAccessManagerAuthTest.assertFalse((boolean)wo.canAccess(this.roUser, this.arcGridLayer, AccessMode.READ));
        DefaultDataAccessManagerAuthTest.assertFalse((boolean)wo.canAccess(this.roUser, this.arcGridLayer, AccessMode.WRITE));
        DefaultDataAccessManagerAuthTest.assertFalse((boolean)wo.canAccess(this.rwUser, this.arcGridLayer, AccessMode.READ));
        DefaultDataAccessManagerAuthTest.assertFalse((boolean)wo.canAccess(this.rwUser, this.arcGridLayer, AccessMode.WRITE));
        DefaultDataAccessManagerAuthTest.assertTrue((boolean)wo.canAccess(this.milUser, this.arcGridLayer, AccessMode.READ));
        DefaultDataAccessManagerAuthTest.assertTrue((boolean)wo.canAccess(this.milUser, this.arcGridLayer, AccessMode.WRITE));
    }

    public void testDefaultMode() throws Exception {
        DataAccessManager wo = this.buildManager("lockedDown.properties");
        DefaultDataAccessManagerAuthTest.assertEquals((Object)DataAccessManager.CatalogMode.HIDE, (Object)wo.getMode());
    }

    public void testHideMode() throws Exception {
        DataAccessManager wo = this.buildManager("lockedDownHide.properties");
        DefaultDataAccessManagerAuthTest.assertEquals((Object)DataAccessManager.CatalogMode.HIDE, (Object)wo.getMode());
    }

    public void testChallengeMode() throws Exception {
        DataAccessManager wo = this.buildManager("lockedDownChallenge.properties");
        DefaultDataAccessManagerAuthTest.assertEquals((Object)DataAccessManager.CatalogMode.CHALLENGE, (Object)wo.getMode());
    }

    public void testMixedMode() throws Exception {
        DataAccessManager wo = this.buildManager("lockedDownMixed.properties");
        DefaultDataAccessManagerAuthTest.assertEquals((Object)DataAccessManager.CatalogMode.MIXED, (Object)wo.getMode());
    }

    public void testUnknownMode() throws Exception {
        DataAccessManager wo = this.buildManager("lockedDownUnknown.properties");
        DefaultDataAccessManagerAuthTest.assertEquals((Object)DataAccessManager.CatalogMode.HIDE, (Object)wo.getMode());
    }
}

