/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.TestingAuthenticationToken;
import org.easymock.EasyMock;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.security.AccessMode;
import org.geoserver.security.DataAccessRuleDAO;
import org.geoserver.security.DefaultDataAccessManager;
import org.geoserver.security.MemoryDataAccessRuleDAO;
import org.geoserver.security.SecureTreeNode;

public class DefaultDataAccessManagerTreeTest
extends TestCase {
    private Catalog catalog;
    private TestingAuthenticationToken rwUser;
    private TestingAuthenticationToken milUser;
    private TestingAuthenticationToken roUser;
    private TestingAuthenticationToken anonymous;

    protected void setUp() throws Exception {
        this.catalog = (Catalog)EasyMock.createNiceMock(Catalog.class);
        EasyMock.expect((Object)this.catalog.getWorkspace((String)EasyMock.anyObject())).andReturn(EasyMock.createNiceMock(WorkspaceInfo.class)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.catalog});
        this.rwUser = new TestingAuthenticationToken((Object)"rw", (Object)"supersecret", new GrantedAuthority[]{new GrantedAuthorityImpl("READER"), new GrantedAuthorityImpl("WRITER")});
        this.roUser = new TestingAuthenticationToken((Object)"ro", (Object)"supersecret", new GrantedAuthority[]{new GrantedAuthorityImpl("READER")});
        this.anonymous = new TestingAuthenticationToken((Object)"anonymous", null, null);
        this.milUser = new TestingAuthenticationToken((Object)"military", (Object)"supersecret", new GrantedAuthority[]{new GrantedAuthorityImpl("MILITARY")});
    }

    private SecureTreeNode buildTree(String propertyFile) throws Exception {
        Properties props = new Properties();
        props.load(((Object)((Object)this)).getClass().getResourceAsStream(propertyFile));
        return new DefaultDataAccessManager((DataAccessRuleDAO)new MemoryDataAccessRuleDAO((Catalog)this.catalog, (Properties)props)).root;
    }

    public void testWideOpen() throws Exception {
        SecureTreeNode root = this.buildTree("wideOpen.properties");
        DefaultDataAccessManagerTreeTest.assertEquals((int)0, (int)root.children.size());
        DefaultDataAccessManagerTreeTest.assertEquals((int)1, (int)root.getAuthorizedRoles(AccessMode.READ).size());
        DefaultDataAccessManagerTreeTest.assertEquals((int)1, (int)root.getAuthorizedRoles(AccessMode.WRITE).size());
        DefaultDataAccessManagerTreeTest.assertTrue((boolean)root.canAccess((Authentication)this.anonymous, AccessMode.READ));
        DefaultDataAccessManagerTreeTest.assertTrue((boolean)root.canAccess((Authentication)this.anonymous, AccessMode.WRITE));
    }

    public void testLockedDown() throws Exception {
        SecureTreeNode root = this.buildTree("lockedDown.properties");
        DefaultDataAccessManagerTreeTest.assertEquals((int)0, (int)root.children.size());
        Set readRoles = root.getAuthorizedRoles(AccessMode.READ);
        DefaultDataAccessManagerTreeTest.assertEquals((int)1, (int)readRoles.size());
        DefaultDataAccessManagerTreeTest.assertTrue((boolean)readRoles.contains("WRITER"));
        Set writeRoles = root.getAuthorizedRoles(AccessMode.WRITE);
        DefaultDataAccessManagerTreeTest.assertEquals((int)1, (int)writeRoles.size());
        DefaultDataAccessManagerTreeTest.assertTrue((boolean)writeRoles.contains("WRITER"));
        DefaultDataAccessManagerTreeTest.assertFalse((boolean)root.canAccess((Authentication)this.anonymous, AccessMode.READ));
        DefaultDataAccessManagerTreeTest.assertFalse((boolean)root.canAccess((Authentication)this.anonymous, AccessMode.WRITE));
        DefaultDataAccessManagerTreeTest.assertFalse((boolean)root.canAccess((Authentication)this.roUser, AccessMode.READ));
        DefaultDataAccessManagerTreeTest.assertFalse((boolean)root.canAccess((Authentication)this.roUser, AccessMode.WRITE));
        DefaultDataAccessManagerTreeTest.assertTrue((boolean)root.canAccess((Authentication)this.rwUser, AccessMode.READ));
        DefaultDataAccessManagerTreeTest.assertTrue((boolean)root.canAccess((Authentication)this.rwUser, AccessMode.WRITE));
    }

    public void testPublicRead() throws Exception {
        SecureTreeNode root = this.buildTree("publicRead.properties");
        DefaultDataAccessManagerTreeTest.assertEquals((int)0, (int)root.children.size());
        DefaultDataAccessManagerTreeTest.assertEquals((Object)SecureTreeNode.EVERYBODY, (Object)root.getAuthorizedRoles(AccessMode.READ));
        Set writeRoles = root.getAuthorizedRoles(AccessMode.WRITE);
        DefaultDataAccessManagerTreeTest.assertEquals((int)1, (int)writeRoles.size());
        DefaultDataAccessManagerTreeTest.assertTrue((boolean)writeRoles.contains("WRITER"));
        DefaultDataAccessManagerTreeTest.assertTrue((boolean)root.canAccess((Authentication)this.anonymous, AccessMode.READ));
        DefaultDataAccessManagerTreeTest.assertFalse((boolean)root.canAccess((Authentication)this.anonymous, AccessMode.WRITE));
        DefaultDataAccessManagerTreeTest.assertTrue((boolean)root.canAccess((Authentication)this.roUser, AccessMode.READ));
        DefaultDataAccessManagerTreeTest.assertFalse((boolean)root.canAccess((Authentication)this.roUser, AccessMode.WRITE));
        DefaultDataAccessManagerTreeTest.assertTrue((boolean)root.canAccess((Authentication)this.rwUser, AccessMode.READ));
        DefaultDataAccessManagerTreeTest.assertTrue((boolean)root.canAccess((Authentication)this.rwUser, AccessMode.WRITE));
    }

    public void testComplex() throws Exception {
        SecureTreeNode root = this.buildTree("complex.properties");
        DefaultDataAccessManagerTreeTest.assertEquals((int)2, (int)root.children.size());
        SecureTreeNode topp = root.getChild("topp");
        DefaultDataAccessManagerTreeTest.assertNotNull((Object)topp);
        DefaultDataAccessManagerTreeTest.assertEquals((int)3, (int)topp.children.size());
        SecureTreeNode states = topp.getChild("states");
        SecureTreeNode landmarks = topp.getChild("landmarks");
        SecureTreeNode bases = topp.getChild("bases");
        DefaultDataAccessManagerTreeTest.assertNotNull((Object)states);
        DefaultDataAccessManagerTreeTest.assertNotNull((Object)landmarks);
        DefaultDataAccessManagerTreeTest.assertNotNull((Object)bases);
        DefaultDataAccessManagerTreeTest.assertFalse((boolean)root.canAccess((Authentication)this.anonymous, AccessMode.READ));
        DefaultDataAccessManagerTreeTest.assertFalse((boolean)root.canAccess((Authentication)this.anonymous, AccessMode.WRITE));
        DefaultDataAccessManagerTreeTest.assertTrue((boolean)topp.canAccess((Authentication)this.anonymous, AccessMode.READ));
        DefaultDataAccessManagerTreeTest.assertFalse((boolean)states.canAccess((Authentication)this.anonymous, AccessMode.READ));
        DefaultDataAccessManagerTreeTest.assertTrue((boolean)landmarks.canAccess((Authentication)this.anonymous, AccessMode.READ));
        DefaultDataAccessManagerTreeTest.assertFalse((boolean)landmarks.canAccess((Authentication)this.anonymous, AccessMode.WRITE));
        DefaultDataAccessManagerTreeTest.assertFalse((boolean)bases.canAccess((Authentication)this.anonymous, AccessMode.READ));
        DefaultDataAccessManagerTreeTest.assertTrue((boolean)root.canAccess((Authentication)this.roUser, AccessMode.READ));
        DefaultDataAccessManagerTreeTest.assertFalse((boolean)root.canAccess((Authentication)this.roUser, AccessMode.WRITE));
        DefaultDataAccessManagerTreeTest.assertTrue((boolean)topp.canAccess((Authentication)this.roUser, AccessMode.READ));
        DefaultDataAccessManagerTreeTest.assertTrue((boolean)states.canAccess((Authentication)this.roUser, AccessMode.READ));
        DefaultDataAccessManagerTreeTest.assertTrue((boolean)landmarks.canAccess((Authentication)this.roUser, AccessMode.READ));
        DefaultDataAccessManagerTreeTest.assertFalse((boolean)landmarks.canAccess((Authentication)this.roUser, AccessMode.WRITE));
        DefaultDataAccessManagerTreeTest.assertFalse((boolean)bases.canAccess((Authentication)this.roUser, AccessMode.READ));
        DefaultDataAccessManagerTreeTest.assertTrue((boolean)root.canAccess((Authentication)this.rwUser, AccessMode.READ));
        DefaultDataAccessManagerTreeTest.assertFalse((boolean)root.canAccess((Authentication)this.rwUser, AccessMode.WRITE));
        DefaultDataAccessManagerTreeTest.assertTrue((boolean)topp.canAccess((Authentication)this.rwUser, AccessMode.READ));
        DefaultDataAccessManagerTreeTest.assertTrue((boolean)states.canAccess((Authentication)this.rwUser, AccessMode.WRITE));
        DefaultDataAccessManagerTreeTest.assertTrue((boolean)landmarks.canAccess((Authentication)this.rwUser, AccessMode.READ));
        DefaultDataAccessManagerTreeTest.assertTrue((boolean)landmarks.canAccess((Authentication)this.rwUser, AccessMode.WRITE));
        DefaultDataAccessManagerTreeTest.assertFalse((boolean)bases.canAccess((Authentication)this.rwUser, AccessMode.READ));
        DefaultDataAccessManagerTreeTest.assertFalse((boolean)root.canAccess((Authentication)this.milUser, AccessMode.READ));
        DefaultDataAccessManagerTreeTest.assertFalse((boolean)root.canAccess((Authentication)this.milUser, AccessMode.WRITE));
        DefaultDataAccessManagerTreeTest.assertTrue((boolean)topp.canAccess((Authentication)this.milUser, AccessMode.READ));
        DefaultDataAccessManagerTreeTest.assertFalse((boolean)states.canAccess((Authentication)this.milUser, AccessMode.WRITE));
        DefaultDataAccessManagerTreeTest.assertTrue((boolean)landmarks.canAccess((Authentication)this.milUser, AccessMode.READ));
        DefaultDataAccessManagerTreeTest.assertFalse((boolean)landmarks.canAccess((Authentication)this.milUser, AccessMode.WRITE));
        DefaultDataAccessManagerTreeTest.assertTrue((boolean)bases.canAccess((Authentication)this.milUser, AccessMode.READ));
        DefaultDataAccessManagerTreeTest.assertTrue((boolean)bases.canAccess((Authentication)this.milUser, AccessMode.WRITE));
    }
}

