/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.util.ArrayList;
import java.util.Iterator;
import org.acegisecurity.AcegiSecurityException;
import org.easymock.EasyMock;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.SecureObjectsTest;
import org.geoserver.security.decorators.ReadOnlyFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;

public class ReadOnlyFeatureCollectionTest
extends SecureObjectsTest {
    private FeatureCollection fc;
    private Feature feature;
    private SortBy sort;

    protected void setUp() throws Exception {
        super.setUp();
        this.feature = (Feature)EasyMock.createNiceMock(Feature.class);
        EasyMock.replay((Object[])new Object[]{this.feature});
        Iterator it = (Iterator)EasyMock.createNiceMock(Iterator.class);
        EasyMock.replay((Object[])new Object[]{it});
        this.sort = (SortBy)EasyMock.createNiceMock(SortBy.class);
        EasyMock.replay((Object[])new Object[]{this.sort});
        SimpleFeatureType schema = (SimpleFeatureType)EasyMock.createNiceMock(SimpleFeatureType.class);
        EasyMock.expect((Object)schema.getTypeName()).andReturn((Object)"testSchema").anyTimes();
        EasyMock.replay((Object[])new Object[]{schema});
        this.fc = (FeatureCollection)EasyMock.createNiceMock(FeatureCollection.class);
        EasyMock.expect((Object)this.fc.iterator()).andReturn((Object)it).anyTimes();
        EasyMock.expect((Object)this.fc.sort(this.sort)).andReturn((Object)this.fc).anyTimes();
        EasyMock.expect((Object)this.fc.subCollection((Filter)Filter.INCLUDE)).andReturn((Object)this.fc).anyTimes();
        EasyMock.expect((Object)this.fc.getSchema()).andReturn((Object)schema).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.fc});
    }

    public void testHide() throws Exception {
        ReadOnlyFeatureCollection ro = new ReadOnlyFeatureCollection(this.fc, SecureCatalogImpl.WrapperPolicy.HIDE);
        try {
            ro.add(this.feature);
            ReadOnlyFeatureCollectionTest.fail((String)"Should have failed with an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            ro.addAll(new ArrayList());
            ReadOnlyFeatureCollectionTest.fail((String)"Should have failed with an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            ro.clear();
            ReadOnlyFeatureCollectionTest.fail((String)"Should have failed with an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            ro.remove((Object)this.feature);
            ReadOnlyFeatureCollectionTest.fail((String)"Should have failed with an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            ro.removeAll(new ArrayList());
            ReadOnlyFeatureCollectionTest.fail((String)"Should have failed with an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            ro.retainAll(new ArrayList());
            ReadOnlyFeatureCollectionTest.fail((String)"Should have failed with an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        Iterator roit = ro.iterator();
        roit.hasNext();
        roit.next();
        try {
            roit.remove();
            ReadOnlyFeatureCollectionTest.fail((String)"Should have failed with an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        ReadOnlyFeatureCollection sorted = (ReadOnlyFeatureCollection)ro.sort(this.sort);
        ReadOnlyFeatureCollectionTest.assertEquals((Object)ro.policy, (Object)sorted.policy);
        ReadOnlyFeatureCollection sub = (ReadOnlyFeatureCollection)ro.subCollection((Filter)Filter.INCLUDE);
        ReadOnlyFeatureCollectionTest.assertEquals((Object)ro.policy, (Object)sorted.policy);
    }

    public void testChallenge() throws Exception {
        ReadOnlyFeatureCollection ro = new ReadOnlyFeatureCollection(this.fc, SecureCatalogImpl.WrapperPolicy.RO_CHALLENGE);
        try {
            ro.add(this.feature);
            ReadOnlyFeatureCollectionTest.fail((String)"Should have failed with an acegi security exception");
        }
        catch (AcegiSecurityException e) {
            // empty catch block
        }
        try {
            ro.addAll(new ArrayList());
            ReadOnlyFeatureCollectionTest.fail((String)"Should have failed with an acegi security exception");
        }
        catch (AcegiSecurityException e) {
            // empty catch block
        }
        try {
            ro.clear();
            ReadOnlyFeatureCollectionTest.fail((String)"Should have failed with an acegi security exception");
        }
        catch (AcegiSecurityException e) {
            // empty catch block
        }
        try {
            ro.remove((Object)this.feature);
            ReadOnlyFeatureCollectionTest.fail((String)"Should have failed with an acegi security exception");
        }
        catch (AcegiSecurityException e) {
            // empty catch block
        }
        try {
            ro.removeAll(new ArrayList());
            ReadOnlyFeatureCollectionTest.fail((String)"Should have failed with an acegi security exception");
        }
        catch (AcegiSecurityException e) {
            // empty catch block
        }
        try {
            ro.retainAll(new ArrayList());
            ReadOnlyFeatureCollectionTest.fail((String)"Should have failed with an acegi security exception");
        }
        catch (AcegiSecurityException e) {
            // empty catch block
        }
        Iterator roit = ro.iterator();
        roit.hasNext();
        roit.next();
        try {
            roit.remove();
            ReadOnlyFeatureCollectionTest.fail((String)"Should have failed with an acegi security exception");
        }
        catch (AcegiSecurityException e) {
            // empty catch block
        }
        ReadOnlyFeatureCollection sorted = (ReadOnlyFeatureCollection)ro.sort(this.sort);
        ReadOnlyFeatureCollectionTest.assertEquals((Object)ro.policy, (Object)sorted.policy);
        ReadOnlyFeatureCollection sub = (ReadOnlyFeatureCollection)ro.subCollection((Filter)Filter.INCLUDE);
        ReadOnlyFeatureCollectionTest.assertEquals((Object)ro.policy, (Object)sorted.policy);
    }
}

