/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.util.List;
import java.util.Set;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.InsufficientAuthenticationException;
import org.acegisecurity.context.SecurityContextHolder;
import org.geoserver.ows.DispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.geoserver.security.ServiceAccessRule;
import org.geoserver.security.ServiceAccessRuleDAO;

public class OperationSecurityCallback
implements DispatcherCallback {
    ServiceAccessRuleDAO dao;

    public OperationSecurityCallback(ServiceAccessRuleDAO dao) {
        this.dao = dao;
    }

    public void finished(Request request) {
    }

    public Request init(Request request) {
        return request;
    }

    public Operation operationDispatched(Request request, Operation operation) {
        Set<String> allowedRoles;
        String service = request.getService();
        String method = request.getRequest();
        List rules = this.dao.getRules();
        ServiceAccessRule bestMatch = null;
        for (ServiceAccessRule rule : rules) {
            if (!rule.getService().equals("*") && !rule.getService().equalsIgnoreCase(service) || !rule.getMethod().equals("*") && !rule.getMethod().equalsIgnoreCase(method)) continue;
            bestMatch = rule;
        }
        if (bestMatch != null && !(allowedRoles = bestMatch.getRoles()).contains("*") && !allowedRoles.isEmpty()) {
            Authentication user = SecurityContextHolder.getContext().getAuthentication();
            if (user == null || user.getAuthorities().length == 0) {
                throw new InsufficientAuthenticationException("Cannot access " + service + "." + method + " as anonymous");
            }
            boolean roleFound = false;
            for (GrantedAuthority role : user.getAuthorities()) {
                if (!allowedRoles.contains(role.getAuthority())) continue;
                roleFound = true;
                break;
            }
            if (!roleFound) {
                throw new AccessDeniedException("Cannot access " + service + "." + method + " with the current privileges");
            }
        }
        return operation;
    }

    public Object operationExecuted(Request request, Operation operation, Object result) {
        return result;
    }

    public Response responseDispatched(Request request, Operation operation, Object result, Response response) {
        return response;
    }

    public Service serviceDispatched(Request request, Service service) throws ServiceException {
        return service;
    }
}

