/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform;

import java.util.List;
import javax.servlet.ServletContext;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.geoserver.platform.GeoServerExtensions;
import org.springframework.context.ApplicationContext;

public class GeoServerExtensionsTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        System.setProperty("TEST_PROPERTY", "ABC");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        System.setProperty("TEST_PROPERTY", "");
    }

    public void testSetApplicationContext() {
        ApplicationContext appContext1 = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);
        ApplicationContext appContext2 = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);
        GeoServerExtensions gse = new GeoServerExtensions();
        gse.setApplicationContext(appContext1);
        GeoServerExtensions.extensionsCache.put(GeoServerExtensionsTest.class, (Object)new String[]{"fake"});
        GeoServerExtensionsTest.assertSame((Object)appContext1, (Object)GeoServerExtensions.context);
        gse.setApplicationContext(appContext2);
        GeoServerExtensionsTest.assertSame((Object)appContext2, (Object)GeoServerExtensions.context);
        GeoServerExtensionsTest.assertEquals((int)0, (int)GeoServerExtensions.extensionsCache.size());
    }

    public void testExtensions() {
        ApplicationContext appContext = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);
        GeoServerExtensions gse = new GeoServerExtensions();
        gse.setApplicationContext(appContext);
        GeoServerExtensionsTest.assertEquals((int)0, (int)GeoServerExtensions.extensionsCache.size());
        EasyMock.expect((Object)appContext.getBeanNamesForType(GeoServerExtensionsTest.class)).andReturn((Object)new String[]{"testKey", "fakeKey"});
        EasyMock.expect((Object)appContext.getBean("testKey")).andReturn((Object)this);
        EasyMock.expect((Object)appContext.getBean("fakeKey")).andReturn(null);
        EasyMock.replay((Object[])new Object[]{appContext});
        List extensions = GeoServerExtensions.extensions(GeoServerExtensionsTest.class);
        GeoServerExtensionsTest.assertNotNull((Object)extensions);
        GeoServerExtensionsTest.assertEquals((int)2, (int)extensions.size());
        GeoServerExtensionsTest.assertTrue((boolean)extensions.contains((Object)this));
        GeoServerExtensionsTest.assertTrue((boolean)extensions.contains(null));
        GeoServerExtensionsTest.assertEquals((int)1, (int)GeoServerExtensions.extensionsCache.size());
        GeoServerExtensionsTest.assertTrue((boolean)GeoServerExtensions.extensionsCache.containsKey(GeoServerExtensionsTest.class));
        GeoServerExtensionsTest.assertNotNull((Object)GeoServerExtensions.extensionsCache.get(GeoServerExtensionsTest.class));
        GeoServerExtensionsTest.assertEquals((int)2, (int)((String[])GeoServerExtensions.extensionsCache.get(GeoServerExtensionsTest.class)).length);
        EasyMock.verify((Object[])new Object[]{appContext});
    }

    public void testExtensionsApplicationContext() {
        ApplicationContext appContext = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);
        ApplicationContext customAppContext = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);
        GeoServerExtensions gse = new GeoServerExtensions();
        gse.setApplicationContext(appContext);
        GeoServerExtensionsTest.assertEquals((int)0, (int)GeoServerExtensions.extensionsCache.size());
        EasyMock.expect((Object)customAppContext.getBeanNamesForType(GeoServerExtensionsTest.class)).andReturn((Object)new String[]{"itDoesntMatterForThePurpose"});
        EasyMock.expect((Object)customAppContext.getBean("itDoesntMatterForThePurpose")).andReturn((Object)this);
        EasyMock.replay((Object[])new Object[]{customAppContext});
        EasyMock.replay((Object[])new Object[]{appContext});
        List extensions = GeoServerExtensions.extensions(GeoServerExtensionsTest.class, (ApplicationContext)customAppContext);
        GeoServerExtensionsTest.assertNotNull((Object)extensions);
        GeoServerExtensionsTest.assertEquals((int)1, (int)extensions.size());
        GeoServerExtensionsTest.assertSame((Object)((Object)this), extensions.get(0));
        GeoServerExtensionsTest.assertEquals((int)0, (int)GeoServerExtensions.extensionsCache.size());
        EasyMock.verify((Object[])new Object[]{appContext});
        EasyMock.verify((Object[])new Object[]{customAppContext});
    }

    public void testBeanString() {
        ApplicationContext appContext = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);
        GeoServerExtensions gse = new GeoServerExtensions();
        gse.setApplicationContext(null);
        GeoServerExtensionsTest.assertNull((Object)GeoServerExtensions.bean((String)"beanName"));
        gse.setApplicationContext(appContext);
        EasyMock.expect((Object)appContext.getBean("beanName")).andReturn(null);
        EasyMock.expect((Object)appContext.getBean("beanName")).andReturn((Object)this);
        EasyMock.replay((Object[])new Object[]{appContext});
        GeoServerExtensionsTest.assertNull((Object)GeoServerExtensions.bean((String)"beanName"));
        GeoServerExtensionsTest.assertSame((Object)((Object)this), (Object)GeoServerExtensions.bean((String)"beanName"));
        EasyMock.verify((Object[])new Object[]{appContext});
    }

    public void _testBeanClassOfT() {
        GeoServerExtensionsTest.fail((String)"Not yet implemented");
    }

    public void _testBeanClassOfTApplicationContext() {
        GeoServerExtensionsTest.fail((String)"Not yet implemented");
    }

    public void _testOnApplicationEvent() {
        GeoServerExtensionsTest.fail((String)"Not yet implemented");
    }

    public void _testCheckContext() {
        GeoServerExtensionsTest.fail((String)"Not yet implemented");
    }

    public void testSystemProperty() {
        GeoServerExtensionsTest.assertEquals((String)"ABC", (String)GeoServerExtensions.getProperty((String)"TEST_PROPERTY", (ApplicationContext)null));
        GeoServerExtensionsTest.assertEquals((String)"ABC", (String)GeoServerExtensions.getProperty((String)"TEST_PROPERTY", (ServletContext)null));
    }

    public void testWebProperty() {
        ServletContext servletContext = (ServletContext)EasyMock.createMock(ServletContext.class);
        EasyMock.expect((Object)servletContext.getInitParameter("TEST_PROPERTY")).andReturn((Object)"DEF").anyTimes();
        EasyMock.expect((Object)servletContext.getInitParameter("WEB_PROPERTY")).andReturn((Object)"WWW").anyTimes();
        EasyMock.replay((Object[])new Object[]{servletContext});
        GeoServerExtensionsTest.assertEquals((String)"ABC", (String)GeoServerExtensions.getProperty((String)"TEST_PROPERTY", (ServletContext)servletContext));
        GeoServerExtensionsTest.assertEquals((String)"WWW", (String)GeoServerExtensions.getProperty((String)"WEB_PROPERTY", (ServletContext)servletContext));
    }
}

